/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.annotation.JsonPOJOBuilder;
import tools.jackson.databind.introspect.AnnotatedAndMetadata;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.AnnotatedConstructor;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.AnnotatedMethod;
import tools.jackson.databind.introspect.BeanPropertyDefinition;
import tools.jackson.databind.introspect.ObjectIdInfo;
import tools.jackson.databind.introspect.PotentialCreators;
import tools.jackson.databind.util.Annotations;
import tools.jackson.databind.util.Converter;

public abstract class BeanDescription {
    protected final JavaType _type;

    protected BeanDescription(JavaType type) {
        this._type = type;
    }

    public Supplier supplier() {
        return new EagerSupplier(this);
    }

    public JavaType getType() {
        return this._type;
    }

    public Class<?> getBeanClass() {
        return this._type.getRawClass();
    }

    public boolean isRecordType() {
        return this._type.isRecordType();
    }

    public boolean isNonStaticInnerClass() {
        return this.getClassInfo().isNonStaticInnerClass();
    }

    public abstract AnnotatedClass getClassInfo();

    public abstract ObjectIdInfo getObjectIdInfo();

    public abstract boolean hasKnownClassAnnotations();

    public abstract Annotations getClassAnnotations();

    public abstract List<BeanPropertyDefinition> findProperties();

    public abstract Set<String> getIgnoredPropertyNames();

    public abstract List<BeanPropertyDefinition> findBackReferences();

    public abstract List<AnnotatedConstructor> getConstructors();

    public abstract List<AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode>> getConstructorsWithMode();

    public abstract List<AnnotatedMethod> getFactoryMethods();

    public abstract List<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> getFactoryMethodsWithMode();

    public abstract AnnotatedConstructor findDefaultConstructor();

    public abstract PotentialCreators getPotentialCreators();

    public AnnotatedMember findJsonKeyAccessor() {
        return null;
    }

    public abstract AnnotatedMember findJsonValueAccessor();

    public abstract AnnotatedMember findAnyGetter();

    public abstract AnnotatedMember findAnySetterAccessor();

    public abstract AnnotatedMethod findMethod(String var1, Class<?>[] var2);

    public abstract JsonInclude.Value findPropertyInclusion(JsonInclude.Value var1);

    @Deprecated
    public abstract JsonFormat.Value findExpectedFormat();

    public abstract JsonFormat.Value findExpectedFormat(Class<?> var1);

    public abstract Converter<Object, Object> findSerializationConverter();

    public abstract Converter<Object, Object> findDeserializationConverter();

    public String findClassDescription() {
        return null;
    }

    public abstract Map<Object, AnnotatedMember> findInjectables();

    public abstract Class<?> findPOJOBuilder();

    public abstract JsonPOJOBuilder.Value findPOJOBuilderConfig();

    public abstract Object instantiateBean(boolean var1);

    public abstract Class<?>[] findDefaultViews();

    public static class EagerSupplier
    implements Supplier {
        protected final BeanDescription _beanDesc;

        public EagerSupplier(BeanDescription beanDesc) {
            this._beanDesc = Objects.requireNonNull(beanDesc);
        }

        @Override
        public Class<?> getBeanClass() {
            return this._beanDesc.getBeanClass();
        }

        @Override
        public boolean isRecordType() {
            return this.getType().isRecordType();
        }

        @Override
        public JavaType getType() {
            return this._beanDesc.getType();
        }

        @Override
        public BeanDescription get() {
            return this._beanDesc;
        }

        @Override
        public AnnotatedClass getClassInfo() {
            return this._beanDesc.getClassInfo();
        }

        @Override
        public Annotations getClassAnnotations() {
            return this._beanDesc.getClassAnnotations();
        }
    }

    public static abstract class LazySupplier
    implements Supplier {
        protected final JavaType _type;
        protected transient AnnotatedClass _classDesc;
        protected transient BeanDescription _beanDesc;

        protected LazySupplier(JavaType type) {
            this._type = type;
        }

        @Override
        public JavaType getType() {
            return this._type;
        }

        @Override
        public Class<?> getBeanClass() {
            return this._type.getRawClass();
        }

        @Override
        public boolean isRecordType() {
            return this._type.isRecordType();
        }

        @Override
        public Annotations getClassAnnotations() {
            return this.getClassInfo().getAnnotations();
        }

        @Override
        public AnnotatedClass getClassInfo() {
            if (this._classDesc == null) {
                this._classDesc = this._introspect(this._type);
            }
            return this._classDesc;
        }

        @Override
        public BeanDescription get() {
            if (this._beanDesc == null) {
                this._beanDesc = this._construct(this._type, this.getClassInfo());
            }
            return this._beanDesc;
        }

        protected abstract AnnotatedClass _introspect(JavaType var1);

        protected abstract BeanDescription _construct(JavaType var1, AnnotatedClass var2);
    }

    public static interface Supplier
    extends java.util.function.Supplier<BeanDescription> {
        @Override
        public BeanDescription get();

        public Annotations getClassAnnotations();

        public Class<?> getBeanClass();

        public AnnotatedClass getClassInfo();

        public JavaType getType();

        public boolean isRecordType();
    }
}

