/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.javatime.ser;

import java.time.Month;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.databind.cfg.EnumFeature;

public class OneBasedMonthSerializer
extends ValueSerializer<Month> {
    private final ValueSerializer<Object> _defaultSerializer;

    public OneBasedMonthSerializer(ValueSerializer<?> defaultSerializer) {
        this._defaultSerializer = defaultSerializer;
    }

    @Override
    public void serialize(Month value, JsonGenerator gen, SerializationContext ctxt) {
        boolean oneBased = ctxt.isEnabled(DateTimeFeature.ONE_BASED_MONTHS);
        if (oneBased && ctxt.isEnabled(EnumFeature.WRITE_ENUMS_USING_INDEX)) {
            gen.writeNumber(value.ordinal() + 1);
            return;
        }
        this._defaultSerializer.serialize(value, gen, ctxt);
    }
}

