/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.javatime.deser;

import java.time.Month;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.databind.deser.std.DelegatingDeserializer;
import tools.jackson.databind.exc.InvalidFormatException;

public class OneBasedMonthDeserializer
extends DelegatingDeserializer {
    public OneBasedMonthDeserializer(ValueDeserializer<?> defaultDeserializer) {
        super(defaultDeserializer);
    }

    @Override
    public Object deserialize(JsonParser parser, DeserializationContext context) {
        boolean oneBased = context.isEnabled(DateTimeFeature.ONE_BASED_MONTHS);
        if (oneBased) {
            JsonToken token = parser.currentToken();
            switch (token) {
                case VALUE_NUMBER_INT: {
                    return this._decodeMonth(parser.getIntValue(), parser);
                }
                case VALUE_STRING: {
                    String monthSpec = parser.getString();
                    int oneBasedMonthNumber = this._decodeNumber(monthSpec);
                    if (oneBasedMonthNumber < 0) break;
                    return this._decodeMonth(oneBasedMonthNumber, parser);
                }
            }
        }
        return this.getDelegatee().deserialize(parser, context);
    }

    private int _decodeNumber(String text) {
        return switch (text.length()) {
            case 1 -> {
                char c = text.charAt(0);
                boolean cValid = '0' <= c && c <= '9';
                yield cValid ? c - 48 : -1;
            }
            case 2 -> {
                char c1 = text.charAt(0);
                char c2 = text.charAt(1);
                boolean c12valid = '0' <= c1 && c1 <= '9' && '0' <= c2 && c2 <= '9';
                yield c12valid ? 10 * (c1 - 48) + (c2 - 48) : -1;
            }
            default -> -1;
        };
    }

    private Month _decodeMonth(int oneBasedMonthNumber, JsonParser parser) throws InvalidFormatException {
        if (Month.JANUARY.getValue() <= oneBasedMonthNumber && oneBasedMonthNumber <= Month.DECEMBER.getValue()) {
            return Month.of(oneBasedMonthNumber);
        }
        throw new InvalidFormatException(parser, "Month number " + oneBasedMonthNumber + " not allowed for 1-based Month.", oneBasedMonthNumber, Integer.class);
    }

    @Override
    protected ValueDeserializer<?> newDelegatingInstance(ValueDeserializer<?> newDelegatee) {
        return new OneBasedMonthDeserializer(newDelegatee);
    }
}

