/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.cfg;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.DatabindContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.cfg.BaseSettings;
import tools.jackson.databind.cfg.CacheProvider;
import tools.jackson.databind.cfg.ConfigFeature;
import tools.jackson.databind.cfg.ConfigOverride;
import tools.jackson.databind.cfg.ConfigOverrides;
import tools.jackson.databind.cfg.ContextAttributes;
import tools.jackson.databind.cfg.DatatypeFeature;
import tools.jackson.databind.cfg.DatatypeFeatures;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.ClassIntrospector;
import tools.jackson.databind.introspect.MixInHandler;
import tools.jackson.databind.introspect.MixInResolver;
import tools.jackson.databind.introspect.VisibilityChecker;
import tools.jackson.databind.jsontype.SubtypeResolver;
import tools.jackson.databind.jsontype.TypeResolverBuilder;
import tools.jackson.databind.jsontype.TypeResolverProvider;
import tools.jackson.databind.node.JsonNodeFactory;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.RootNameLookup;

public abstract class MapperConfigBase<CFG extends ConfigFeature, T extends MapperConfigBase<CFG, T>>
extends MapperConfig<T>
implements Serializable {
    protected static final ConfigOverride EMPTY_OVERRIDE = ConfigOverride.empty();
    protected final TypeFactory _typeFactory;
    protected final ClassIntrospector _classIntrospector;
    protected final TypeResolverProvider _typeResolverProvider;
    protected final SubtypeResolver _subtypeResolver;
    protected final MixInHandler _mixIns;
    protected final PropertyName _rootName;
    protected final Class<?> _view;
    protected final ContextAttributes _attributes;
    protected final RootNameLookup _rootNames;
    protected final ConfigOverrides _configOverrides;
    protected final DatatypeFeatures _datatypeFeatures;

    protected MapperConfigBase(MapperBuilder<?, ?> b, long mapperFeatures, TypeFactory tf, ClassIntrospector classIntr, MixInHandler mixins, SubtypeResolver str, ConfigOverrides configOverrides, ContextAttributes defaultAttrs, RootNameLookup rootNames) {
        super(b.baseSettings(), mapperFeatures);
        this._typeFactory = tf;
        this._classIntrospector = classIntr;
        this._typeResolverProvider = b.typeResolverProvider();
        this._subtypeResolver = str;
        this._mixIns = mixins;
        this._rootNames = rootNames;
        this._rootName = null;
        this._view = null;
        this._attributes = defaultAttrs;
        this._configOverrides = configOverrides;
        this._datatypeFeatures = b.datatypeFeatures();
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src) {
        super(src);
        this._typeFactory = src._typeFactory;
        this._classIntrospector = src._classIntrospector;
        this._typeResolverProvider = src._typeResolverProvider;
        this._subtypeResolver = src._subtypeResolver;
        this._mixIns = src._mixIns;
        this._rootNames = src._rootNames;
        this._rootName = src._rootName;
        this._view = src._view;
        this._attributes = src._attributes;
        this._configOverrides = src._configOverrides;
        this._datatypeFeatures = src._datatypeFeatures;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src, BaseSettings base) {
        super(src, base);
        this._typeFactory = src._typeFactory;
        this._classIntrospector = src._classIntrospector;
        this._typeResolverProvider = src._typeResolverProvider;
        this._subtypeResolver = src._subtypeResolver;
        this._mixIns = src._mixIns;
        this._rootNames = src._rootNames;
        this._rootName = src._rootName;
        this._view = src._view;
        this._attributes = src._attributes;
        this._configOverrides = src._configOverrides;
        this._datatypeFeatures = src._datatypeFeatures;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src, PropertyName rootName) {
        super(src);
        this._typeFactory = src._typeFactory;
        this._classIntrospector = src._classIntrospector;
        this._typeResolverProvider = src._typeResolverProvider;
        this._subtypeResolver = src._subtypeResolver;
        this._mixIns = src._mixIns;
        this._rootNames = src._rootNames;
        this._rootName = rootName;
        this._view = src._view;
        this._attributes = src._attributes;
        this._configOverrides = src._configOverrides;
        this._datatypeFeatures = src._datatypeFeatures;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src, Class<?> view) {
        super(src);
        this._typeFactory = src._typeFactory;
        this._classIntrospector = src._classIntrospector;
        this._typeResolverProvider = src._typeResolverProvider;
        this._subtypeResolver = src._subtypeResolver;
        this._mixIns = src._mixIns;
        this._rootNames = src._rootNames;
        this._rootName = src._rootName;
        this._view = view;
        this._attributes = src._attributes;
        this._configOverrides = src._configOverrides;
        this._datatypeFeatures = src._datatypeFeatures;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src, ContextAttributes attr) {
        super(src);
        this._typeFactory = src._typeFactory;
        this._classIntrospector = src._classIntrospector;
        this._typeResolverProvider = src._typeResolverProvider;
        this._subtypeResolver = src._subtypeResolver;
        this._mixIns = src._mixIns;
        this._rootNames = src._rootNames;
        this._rootName = src._rootName;
        this._view = src._view;
        this._attributes = attr;
        this._configOverrides = src._configOverrides;
        this._datatypeFeatures = src._datatypeFeatures;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src, DatatypeFeatures datatypeFeatures) {
        super(src);
        this._typeFactory = src._typeFactory;
        this._classIntrospector = src._classIntrospector;
        this._typeResolverProvider = src._typeResolverProvider;
        this._subtypeResolver = src._subtypeResolver;
        this._mixIns = src._mixIns;
        this._rootNames = src._rootNames;
        this._rootName = src._rootName;
        this._view = src._view;
        this._attributes = src._attributes;
        this._configOverrides = src._configOverrides;
        this._datatypeFeatures = datatypeFeatures;
    }

    protected abstract T _withBase(BaseSettings var1);

    protected abstract T _with(DatatypeFeatures var1);

    protected DatatypeFeatures _datatypeFeatures() {
        return this._datatypeFeatures;
    }

    public final T with(DatatypeFeature feature) {
        return this._with(this._datatypeFeatures().with(feature));
    }

    public final T withFeatures(DatatypeFeature ... features) {
        return this._with(this._datatypeFeatures().withFeatures(features));
    }

    public final T without(DatatypeFeature feature) {
        return this._with(this._datatypeFeatures().without(feature));
    }

    public final T withoutFeatures(DatatypeFeature ... features) {
        return this._with(this._datatypeFeatures().withoutFeatures(features));
    }

    public final T with(DatatypeFeature feature, boolean state) {
        DatatypeFeatures features = this._datatypeFeatures();
        features = state ? features.with(feature) : features.without(feature);
        return this._with(features);
    }

    public abstract T with(ContextAttributes var1);

    public T withAttributes(Map<?, ?> attributes) {
        return this.with(this.getAttributes().withSharedAttributes(attributes));
    }

    public T withAttribute(Object key, Object value) {
        return this.with(this.getAttributes().withSharedAttribute(key, value));
    }

    public T withoutAttribute(Object key) {
        return this.with(this.getAttributes().withoutSharedAttribute(key));
    }

    public final T with(TypeResolverBuilder<?> trb) {
        return this._withBase(this._base.with(trb));
    }

    public T with(CacheProvider provider) {
        return this._withBase(this._base.with(Objects.requireNonNull(provider)));
    }

    public final T with(JsonNodeFactory f) {
        return this._withBase(this._base.with(f));
    }

    public final T with(Base64Variant base64) {
        return this._withBase(this._base.with(base64));
    }

    public T with(DateFormat df) {
        return this._withBase(this._base.with(df));
    }

    public final T with(Locale l) {
        return this._withBase(this._base.with(l));
    }

    public final T with(TimeZone tz) {
        return this._withBase(this._base.with(tz));
    }

    public abstract T withRootName(PropertyName var1);

    public T withRootName(String rootName) {
        if (rootName == null) {
            return this.withRootName((PropertyName)null);
        }
        return this.withRootName(PropertyName.construct(rootName));
    }

    public abstract T withView(Class<?> var1);

    @Override
    public final TypeFactory getTypeFactory() {
        return this._typeFactory;
    }

    @Override
    public ClassIntrospector classIntrospectorInstance() {
        return this._classIntrospector.forOperation(this);
    }

    @Override
    public TypeResolverProvider getTypeResolverProvider() {
        return this._typeResolverProvider;
    }

    @Override
    public final SubtypeResolver getSubtypeResolver() {
        return this._subtypeResolver;
    }

    @Override
    public final JavaType constructType(Class<?> cls) {
        return this._typeFactory.constructType(cls);
    }

    @Override
    public final JavaType constructType(TypeReference<?> valueTypeRef) {
        return this._typeFactory.constructType(valueTypeRef.getType());
    }

    @Override
    public final boolean isEnabled(DatatypeFeature feature) {
        return this._datatypeFeatures.isEnabled(feature);
    }

    @Override
    public final DatatypeFeatures getDatatypeFeatures() {
        return this._datatypeFeatures;
    }

    public final PropertyName getFullRootName() {
        return this._rootName;
    }

    @Override
    public final Class<?> getActiveView() {
        return this._view;
    }

    @Override
    public final ContextAttributes getAttributes() {
        return this._attributes;
    }

    @Override
    public final ConfigOverride getConfigOverride(Class<?> type) {
        ConfigOverride override = this._configOverrides.findOverride(type);
        return override == null ? EMPTY_OVERRIDE : override;
    }

    @Override
    public final ConfigOverride findConfigOverride(Class<?> type) {
        return this._configOverrides.findOverride(type);
    }

    @Override
    public final JsonInclude.Value getDefaultPropertyInclusion() {
        return this._configOverrides.getDefaultInclusion();
    }

    @Override
    public final JsonInclude.Value getDefaultPropertyInclusion(Class<?> baseType) {
        JsonInclude.Value v = this.getConfigOverride(baseType).getInclude();
        JsonInclude.Value def = this.getDefaultPropertyInclusion();
        if (def == null) {
            return v;
        }
        return def.withOverrides(v);
    }

    @Override
    public final JsonInclude.Value getDefaultInclusion(Class<?> baseType, Class<?> propertyType) {
        JsonInclude.Value v = this.getConfigOverride(propertyType).getIncludeAsProperty();
        JsonInclude.Value def = this.getDefaultPropertyInclusion(baseType);
        if (def == null) {
            return v;
        }
        return def.withOverrides(v);
    }

    @Override
    public final JsonFormat.Value getDefaultPropertyFormat(Class<?> type) {
        return this._configOverrides.findFormatDefaults(type);
    }

    @Override
    public final JsonIgnoreProperties.Value getDefaultPropertyIgnorals(Class<?> type) {
        JsonIgnoreProperties.Value v;
        ConfigOverride overrides = this._configOverrides.findOverride(type);
        if (overrides != null && (v = overrides.getIgnorals()) != null) {
            return v;
        }
        return null;
    }

    @Override
    public final JsonIgnoreProperties.Value getDefaultPropertyIgnorals(Class<?> baseType, AnnotatedClass actualClass) {
        AnnotationIntrospector intr = this.getAnnotationIntrospector();
        JsonIgnoreProperties.Value base = intr == null ? null : intr.findPropertyIgnoralByName(this, actualClass);
        JsonIgnoreProperties.Value overrides = this.getDefaultPropertyIgnorals(baseType);
        return JsonIgnoreProperties.Value.merge((JsonIgnoreProperties.Value)base, (JsonIgnoreProperties.Value)overrides);
    }

    @Override
    public final JsonIncludeProperties.Value getDefaultPropertyInclusions(Class<?> baseType, AnnotatedClass actualClass) {
        AnnotationIntrospector intr = this.getAnnotationIntrospector();
        return intr == null ? null : intr.findPropertyInclusionByName(this, actualClass);
    }

    @Override
    public final VisibilityChecker getDefaultVisibilityChecker() {
        return this._configOverrides.getDefaultVisibility();
    }

    @Override
    public final VisibilityChecker getDefaultVisibilityChecker(Class<?> baseType, AnnotatedClass actualClass) {
        ConfigOverride overrides;
        VisibilityChecker vc = ClassUtil.isJDKClass(baseType) ? VisibilityChecker.allPublicInstance() : (ClassUtil.isRecordType(baseType) ? this._configOverrides.getDefaultRecordVisibility() : this.getDefaultVisibilityChecker());
        AnnotationIntrospector intr = this.getAnnotationIntrospector();
        if (intr != null) {
            vc = intr.findAutoDetectVisibility(this, actualClass, vc);
        }
        if ((overrides = this._configOverrides.findOverride(baseType)) != null) {
            vc = vc.withOverrides(overrides.getVisibility());
        }
        return vc;
    }

    @Override
    public final JsonSetter.Value getDefaultNullHandling() {
        return this._configOverrides.getDefaultNullHandling();
    }

    @Override
    public Boolean getDefaultMergeable() {
        return this._configOverrides.getDefaultMergeable();
    }

    @Override
    public Boolean getDefaultMergeable(Class<?> baseType) {
        Boolean b;
        ConfigOverride cfg = this._configOverrides.findOverride(baseType);
        if (cfg != null && (b = cfg.getMergeable()) != null) {
            return b;
        }
        return this._configOverrides.getDefaultMergeable();
    }

    @Override
    public PropertyName findRootName(DatabindContext ctxt, JavaType rootType) {
        if (this._rootName != null) {
            return this._rootName;
        }
        return this._rootNames.findRootName(ctxt, rootType);
    }

    @Override
    public PropertyName findRootName(DatabindContext ctxt, Class<?> rawRootType) {
        if (this._rootName != null) {
            return this._rootName;
        }
        return this._rootNames.findRootName(ctxt, rawRootType);
    }

    @Override
    public final Class<?> findMixInClassFor(Class<?> cls) {
        return this._mixIns.findMixInClassFor(cls);
    }

    @Override
    public boolean hasMixIns() {
        return this._mixIns.hasMixIns();
    }

    @Override
    public MixInResolver snapshot() {
        throw new UnsupportedOperationException();
    }

    public final int mixInCount() {
        return this._mixIns.localSize();
    }
}

