/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.JacksonSerializable;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ValueNode;
import tools.jackson.databind.util.ClassUtil;

public class POJONode
extends ValueNode {
    private static final long serialVersionUID = 3L;
    protected final Object _value;

    public POJONode(Object v) {
        this._value = v;
    }

    @Override
    protected String _valueDesc() {
        return "{POJO of type " + ClassUtil.classNameOf(this._value) + "}";
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.POJO;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    @Override
    public boolean isEmbeddedValue() {
        return true;
    }

    @Override
    protected Boolean _asBoolean() {
        if (this._value == null) {
            return Boolean.FALSE;
        }
        Object object = this._value;
        if (object instanceof Boolean) {
            Boolean B = (Boolean)object;
            return B;
        }
        return null;
    }

    @Override
    protected String _asString() {
        Object object = this._value;
        if (object instanceof String) {
            String str = (String)object;
            return str;
        }
        return null;
    }

    @Override
    public byte[] binaryValue() {
        if (this._value instanceof byte[]) {
            return (byte[])this._value;
        }
        return super.binaryValue();
    }

    @Override
    public int asInt() {
        Integer I = this._extractAsInteger();
        return I == null ? super.asInt() : I.intValue();
    }

    @Override
    public int asInt(int defaultValue) {
        Integer I = this._extractAsInteger();
        return I == null ? defaultValue : I;
    }

    @Override
    public OptionalInt asIntOpt() {
        Integer I = this._extractAsInteger();
        return I == null ? OptionalInt.empty() : OptionalInt.of(I);
    }

    @Override
    public long asLong() {
        Long L = this._extractAsLong();
        return L == null ? super.asLong() : L.longValue();
    }

    @Override
    public long asLong(long defaultValue) {
        Long L = this._extractAsLong();
        return L == null ? defaultValue : L;
    }

    @Override
    public OptionalLong asLongOpt() {
        Long L = this._extractAsLong();
        return L == null ? OptionalLong.empty() : OptionalLong.of(L);
    }

    @Override
    public BigInteger asBigInteger() {
        BigInteger big = this._extractAsBigInteger();
        return big == null ? super.asBigInteger() : big;
    }

    @Override
    public BigInteger asBigInteger(BigInteger defaultValue) {
        BigInteger big = this._extractAsBigInteger();
        return big == null ? defaultValue : big;
    }

    @Override
    public Optional<BigInteger> asBigIntegerOpt() {
        BigInteger big = this._extractAsBigInteger();
        return big == null ? Optional.empty() : Optional.of(big);
    }

    @Override
    public double asDouble() {
        Double d = this._extractAsDouble();
        return d == null ? super.asDouble() : d.doubleValue();
    }

    @Override
    public double asDouble(double defaultValue) {
        Double d = this._extractAsDouble();
        return d == null ? defaultValue : d;
    }

    @Override
    public OptionalDouble asDoubleOpt() {
        Double d = this._extractAsDouble();
        return d == null ? OptionalDouble.empty() : OptionalDouble.of(d);
    }

    @Override
    public BigDecimal asDecimal() {
        BigDecimal dec = this._extractAsBigDecimal();
        if (dec == null) {
            return super.asDecimal();
        }
        return dec;
    }

    @Override
    public BigDecimal asDecimal(BigDecimal defaultValue) {
        BigDecimal dec = this._extractAsBigDecimal();
        if (dec == null) {
            return defaultValue;
        }
        return dec;
    }

    @Override
    public Optional<BigDecimal> asDecimalOpt() {
        BigDecimal dec = this._extractAsBigDecimal();
        return dec == null ? Optional.empty() : Optional.of(dec);
    }

    protected Integer _extractAsInteger() {
        Number N;
        if (this._value == null) {
            return 0;
        }
        Object object = this._value;
        if (object instanceof Number && ((N = (Number)object) instanceof Long || N instanceof Integer || N instanceof Short || N instanceof Byte || N instanceof BigInteger)) {
            return N.intValue();
        }
        return null;
    }

    protected Long _extractAsLong() {
        Number N;
        if (this._value == null) {
            return 0L;
        }
        Object object = this._value;
        if (object instanceof Number && ((N = (Number)object) instanceof Long || N instanceof Integer || N instanceof Short || N instanceof Byte || N instanceof BigInteger)) {
            return N.longValue();
        }
        return null;
    }

    protected BigInteger _extractAsBigInteger() {
        Number N;
        if (this._value == null) {
            return BigInteger.ZERO;
        }
        Object object = this._value;
        if (object instanceof BigInteger) {
            BigInteger big = (BigInteger)object;
            return big;
        }
        object = this._value;
        if (object instanceof Number && ((N = (Number)object) instanceof Long || N instanceof Integer || N instanceof Short || N instanceof Byte)) {
            return BigInteger.valueOf(N.longValue());
        }
        return null;
    }

    protected Double _extractAsDouble() {
        Object object = this._value;
        if (object instanceof Number) {
            Number N = (Number)object;
            Object object2 = this._value;
            if (object2 instanceof Double) {
                Double D = (Double)object2;
                return D;
            }
            return N.doubleValue();
        }
        return null;
    }

    protected BigDecimal _extractAsBigDecimal() {
        if (this._value == null) {
            return BigDecimal.ZERO;
        }
        Object object = this._value;
        if (object instanceof BigDecimal) {
            BigDecimal dec = (BigDecimal)object;
            return dec;
        }
        object = this._value;
        if (object instanceof BigInteger) {
            BigInteger I = (BigInteger)object;
            return new BigDecimal(I);
        }
        object = this._value;
        if (object instanceof Number) {
            Number N = (Number)object;
            if (N instanceof Long || N instanceof Integer || N instanceof Short || N instanceof Byte) {
                return BigDecimal.valueOf(N.longValue());
            }
            try {
                return BigDecimal.valueOf(N.doubleValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public final void serialize(JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
        if (this._value == null) {
            ctxt.defaultSerializeNullValue(gen);
        } else if (this._value instanceof JacksonSerializable) {
            ((JacksonSerializable)this._value).serialize(gen, ctxt);
        } else {
            ctxt.writeValue(gen, this._value);
        }
    }

    public Object getPojo() {
        return this._value;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof POJONode) {
            return this._pojoEquals((POJONode)o);
        }
        return false;
    }

    protected boolean _pojoEquals(POJONode other) {
        if (this._value == null) {
            return other._value == null;
        }
        return this._value.equals(other._value);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this._value);
    }
}

