/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.NumericFPNode;

public class DecimalNode
extends NumericFPNode {
    private static final long serialVersionUID = 3L;
    public static final DecimalNode ZERO = new DecimalNode(BigDecimal.ZERO);
    private static final BigDecimal MIN_SHORT = BigDecimal.valueOf(-32768L);
    private static final BigDecimal MAX_SHORT = BigDecimal.valueOf(32767L);
    private static final BigDecimal MIN_INTEGER = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal MAX_INTEGER = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    protected final BigDecimal _value;

    public DecimalNode(BigDecimal v) {
        this._value = Objects.requireNonNull(v);
    }

    public static DecimalNode valueOf(BigDecimal d) {
        return new DecimalNode(d);
    }

    @Override
    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.BIG_DECIMAL;
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public boolean isNaN() {
        return false;
    }

    @Override
    public String _asString() {
        return this._value.toString();
    }

    @Override
    public Number numberValue() {
        return this._value;
    }

    @Override
    public float floatValue() {
        float f = this._value.floatValue();
        if (Float.isFinite(f)) {
            return f;
        }
        return this._reportFloatCoercionRangeFail("floatValue()");
    }

    @Override
    public double doubleValue() {
        double d = this._value.doubleValue();
        if (Double.isFinite(d)) {
            return d;
        }
        return this._reportDoubleCoercionRangeFail("doubleValue()");
    }

    @Override
    public double doubleValue(double defaultValue) {
        double d = this._value.doubleValue();
        if (Double.isFinite(d)) {
            return d;
        }
        return defaultValue;
    }

    @Override
    public OptionalDouble doubleValueOpt() {
        double d = this._value.doubleValue();
        if (Double.isFinite(d)) {
            return OptionalDouble.of(this._value.doubleValue());
        }
        return OptionalDouble.empty();
    }

    @Override
    public double asDouble() {
        double d = this._value.doubleValue();
        if (Double.isFinite(d)) {
            return d;
        }
        return this._reportDoubleCoercionRangeFail("asDouble()");
    }

    @Override
    public double asDouble(double defaultValue) {
        double d = this._value.doubleValue();
        if (Double.isFinite(d)) {
            return d;
        }
        return defaultValue;
    }

    @Override
    public OptionalDouble asDoubleOpt() {
        double d = this._value.doubleValue();
        if (Double.isFinite(d)) {
            return OptionalDouble.of(this._value.doubleValue());
        }
        return OptionalDouble.empty();
    }

    @Override
    public BigDecimal decimalValue() {
        return this._value;
    }

    @Override
    public BigDecimal decimalValue(BigDecimal defaultValue) {
        return this._value;
    }

    @Override
    public Optional<BigDecimal> decimalValueOpt() {
        return Optional.of(this._value);
    }

    @Override
    public BigDecimal asDecimal() {
        return this._value;
    }

    @Override
    public BigDecimal asDecimal(BigDecimal defaultValue) {
        return this._value;
    }

    @Override
    public Optional<BigDecimal> asDecimalOpt() {
        return Optional.of(this._value);
    }

    @Override
    protected short _asShortValueUnchecked() {
        return this._value.shortValue();
    }

    @Override
    protected int _asIntValueUnchecked() {
        return this._value.intValue();
    }

    @Override
    protected long _asLongValueUnchecked() {
        return this._value.longValue();
    }

    @Override
    protected BigInteger _asBigIntegerValueUnchecked() {
        return this._value.toBigInteger();
    }

    @Override
    protected BigDecimal _asDecimalValueUnchecked() {
        return this._value;
    }

    @Override
    protected boolean _hasFractionalPart() {
        return this._value.signum() != 0 && this._value.scale() > 0 && this._value.stripTrailingZeros().scale() > 0;
    }

    @Override
    protected boolean _inShortRange() {
        return this._value.compareTo(MIN_SHORT) >= 0 && this._value.compareTo(MAX_SHORT) <= 0;
    }

    @Override
    protected boolean _inIntRange() {
        return this._value.compareTo(MIN_INTEGER) >= 0 && this._value.compareTo(MAX_INTEGER) <= 0;
    }

    @Override
    protected boolean _inLongRange() {
        return this._value.compareTo(MIN_LONG) >= 0 && this._value.compareTo(MAX_LONG) <= 0;
    }

    @Override
    public final void serialize(JsonGenerator g, SerializationContext provider) throws JacksonException {
        g.writeNumber(this._value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof DecimalNode) {
            DecimalNode otherNode = (DecimalNode)o;
            return otherNode._value.equals(this._value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._value.hashCode();
    }
}

