/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.util.ClassUtil;

public class BeanUtil {
    public static String stdManglePropertyName(String basename, int offset) {
        char c1;
        int end = basename.length();
        if (end == offset) {
            return null;
        }
        char c0 = basename.charAt(offset);
        if (c0 == (c1 = Character.toLowerCase(c0))) {
            return basename.substring(offset);
        }
        if (offset + 1 < end && Character.isUpperCase(basename.charAt(offset + 1))) {
            return basename.substring(offset);
        }
        StringBuilder sb = new StringBuilder(end - offset);
        sb.append(c1);
        sb.append(basename, offset + 1, end);
        return sb.toString();
    }

    public static Object getDefaultValue(JavaType type) {
        Class<?> cls = type.getRawClass();
        Class<?> prim = ClassUtil.primitiveType(cls);
        if (prim != null) {
            return ClassUtil.defaultValue(prim);
        }
        if (type.isContainerType() || type.isReferenceType()) {
            return JsonInclude.Include.NON_EMPTY;
        }
        if (cls == String.class) {
            return "";
        }
        if (type.isTypeOrSubTypeOf(Date.class)) {
            return new Date(0L);
        }
        if (type.isTypeOrSubTypeOf(Calendar.class)) {
            GregorianCalendar c = new GregorianCalendar();
            c.setTimeInMillis(0L);
            return c;
        }
        return null;
    }

    public static String checkUnsupportedType(JavaType type) {
        String moduleName;
        String typeName;
        String className = type.getRawClass().getName();
        if (BeanUtil.isJava8TimeClass(className)) {
            if (className.indexOf(46, 10) >= 0) {
                return null;
            }
            if (type.isTypeOrSubTypeOf(Throwable.class)) {
                return null;
            }
            typeName = "Java 8 date/time";
            moduleName = "com.fasterxml.jackson.datatype:jackson-datatype-jsr310";
        } else if (BeanUtil.isJodaTimeClass(className)) {
            typeName = "Joda date/time";
            moduleName = "com.fasterxml.jackson.datatype:jackson-datatype-joda";
        } else {
            return null;
        }
        return String.format("%s type %s not supported by default: add Module \"%s\" to enable handling", typeName, ClassUtil.getTypeDescription(type), moduleName);
    }

    public static boolean isJava8TimeClass(Class<?> rawType) {
        return BeanUtil.isJava8TimeClass(rawType.getName());
    }

    private static boolean isJava8TimeClass(String className) {
        return className.startsWith("java.time.");
    }

    public static boolean isJodaTimeClass(Class<?> rawType) {
        return BeanUtil.isJodaTimeClass(rawType.getName());
    }

    private static boolean isJodaTimeClass(String className) {
        return className.startsWith("org.joda.time.");
    }
}

