/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.io.NumberOutput;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.NumericNode;

public class DoubleNode
extends NumericNode {
    private static final long serialVersionUID = 3L;
    protected final double _value;

    public DoubleNode(double v) {
        this._value = v;
    }

    public static DoubleNode valueOf(double v) {
        return new DoubleNode(v);
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    @Override
    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.DOUBLE;
    }

    @Override
    public boolean isFloatingPointNumber() {
        return true;
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public boolean canConvertToInt() {
        return this.canConvertToExactIntegral() && this._inIntRange();
    }

    @Override
    public boolean canConvertToLong() {
        return this.canConvertToExactIntegral() && this._inLongRange();
    }

    @Override
    public boolean canConvertToExactIntegral() {
        return !this.isNaN() && !this._hasFractionalPart();
    }

    @Override
    public Number numberValue() {
        return this._value;
    }

    @Override
    public short shortValue() {
        if (!this._inShortRange()) {
            return this._reportShortCoercionRangeFail("shortValue()");
        }
        if (this._hasFractionalPart()) {
            this._reportShortCoercionFractionFail("shortValue()");
        }
        return (short)this._value;
    }

    @Override
    public int intValue() {
        if (!this._inIntRange()) {
            return this._reportIntCoercionRangeFail("intValue()");
        }
        if (this._hasFractionalPart()) {
            this._reportIntCoercionFractionFail("intValue()");
        }
        return (int)this._value;
    }

    @Override
    public int intValue(int defaultValue) {
        if (!this._inIntRange() || this._hasFractionalPart()) {
            return defaultValue;
        }
        return (int)this._value;
    }

    @Override
    public OptionalInt intValueOpt() {
        if (!this._inIntRange() || this._hasFractionalPart()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of((int)this._value);
    }

    @Override
    public long longValue() {
        if (!this._inLongRange()) {
            return this._reportLongCoercionRangeFail("longValue()");
        }
        if (this._hasFractionalPart()) {
            this._reportLongCoercionFractionFail("longValue()");
        }
        return (long)this._value;
    }

    @Override
    public long longValue(long defaultValue) {
        if (!this._inLongRange() || this._hasFractionalPart()) {
            return defaultValue;
        }
        return (long)this._value;
    }

    @Override
    public OptionalLong longValueOpt() {
        if (!this._inLongRange() || this._hasFractionalPart()) {
            return OptionalLong.empty();
        }
        return OptionalLong.of((long)this._value);
    }

    @Override
    public BigInteger bigIntegerValue() {
        if (this._hasFractionalPart()) {
            this._reportBigIntegerCoercionFractionFail("bigIntegerValue()");
        }
        return this.decimalValue().toBigInteger();
    }

    @Override
    public float floatValue() {
        float f = (float)this._value;
        if (Float.isFinite(f)) {
            return f;
        }
        return this._reportFloatCoercionRangeFail("floatValue()");
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    @Override
    public double doubleValue(double defaultValue) {
        return this._value;
    }

    @Override
    public OptionalDouble doubleValueOpt() {
        return OptionalDouble.of(this._value);
    }

    @Override
    public BigDecimal decimalValue() {
        return BigDecimal.valueOf(this._value);
    }

    @Override
    public BigDecimal decimalValue(BigDecimal defaultValue) {
        return this.decimalValue();
    }

    @Override
    public Optional<BigDecimal> decimalValueOpt() {
        return Optional.of(this.decimalValue());
    }

    @Override
    public String asString() {
        return String.valueOf(this._value);
    }

    @Override
    public boolean isNaN() {
        return NumberOutput.notFinite((double)this._value);
    }

    @Override
    public final void serialize(JsonGenerator g, SerializationContext provider) throws JacksonException {
        g.writeNumber(this._value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof DoubleNode) {
            double otherValue = ((DoubleNode)o)._value;
            return Double.compare(this._value, otherValue) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long l = Double.doubleToLongBits(this._value);
        return (int)l ^ (int)(l >> 32);
    }

    private boolean _hasFractionalPart() {
        return this._value != Math.rint(this._value);
    }

    private boolean _inShortRange() {
        return !this.isNaN() && this._value >= -32768.0 && this._value <= 32767.0;
    }

    private boolean _inIntRange() {
        return !this.isNaN() && this._value >= -2.147483648E9 && this._value <= 2.147483647E9;
    }

    private boolean _inLongRange() {
        return !this.isNaN() && this._value >= -9.223372036854776E18 && this._value <= 9.223372036854776E18;
    }
}

