/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import tools.jackson.core.JsonPointer;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.BinaryNode;
import tools.jackson.databind.node.BooleanNode;
import tools.jackson.databind.node.JsonNodeCreator;
import tools.jackson.databind.node.JsonNodeFactory;
import tools.jackson.databind.node.NullNode;
import tools.jackson.databind.node.NumericNode;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.node.StringNode;
import tools.jackson.databind.node.ValueNode;
import tools.jackson.databind.util.RawValue;

public abstract class ContainerNode<T extends ContainerNode<T>>
extends BaseJsonNode
implements JsonNodeCreator {
    private static final long serialVersionUID = 3L;
    protected final JsonNodeFactory _nodeFactory;

    protected ContainerNode(JsonNodeFactory nc) {
        this._nodeFactory = nc;
    }

    protected ContainerNode() {
        this._nodeFactory = null;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public abstract JsonToken asToken();

    @Override
    public String asString() {
        return "";
    }

    @Override
    public abstract int size();

    @Override
    public abstract JsonNode get(int var1);

    @Override
    public abstract JsonNode get(String var1);

    @Override
    public abstract Stream<JsonNode> valueStream();

    @Override
    protected abstract ObjectNode _withObject(JsonPointer var1, JsonPointer var2, JsonNode.OverwriteMode var3, boolean var4);

    @Override
    public final BooleanNode booleanNode(boolean v) {
        return this._nodeFactory.booleanNode(v);
    }

    @Override
    public JsonNode missingNode() {
        return this._nodeFactory.missingNode();
    }

    @Override
    public final NullNode nullNode() {
        return this._nodeFactory.nullNode();
    }

    @Override
    public final ArrayNode arrayNode() {
        return this._nodeFactory.arrayNode();
    }

    @Override
    public final ArrayNode arrayNode(int capacity) {
        return this._nodeFactory.arrayNode(capacity);
    }

    @Override
    public final ObjectNode objectNode() {
        return this._nodeFactory.objectNode();
    }

    @Override
    public final NumericNode numberNode(byte v) {
        return this._nodeFactory.numberNode(v);
    }

    @Override
    public final NumericNode numberNode(short v) {
        return this._nodeFactory.numberNode(v);
    }

    @Override
    public final NumericNode numberNode(int v) {
        return this._nodeFactory.numberNode(v);
    }

    @Override
    public final NumericNode numberNode(long v) {
        return this._nodeFactory.numberNode(v);
    }

    @Override
    public final NumericNode numberNode(float v) {
        return this._nodeFactory.numberNode(v);
    }

    @Override
    public final NumericNode numberNode(double v) {
        return this._nodeFactory.numberNode(v);
    }

    @Override
    public final ValueNode numberNode(BigInteger v) {
        return this._nodeFactory.numberNode(v);
    }

    @Override
    public final ValueNode numberNode(BigDecimal v) {
        return this._nodeFactory.numberNode(v);
    }

    @Override
    public final ValueNode numberNode(Byte v) {
        return this._nodeFactory.numberNode(v);
    }

    @Override
    public final ValueNode numberNode(Short v) {
        return this._nodeFactory.numberNode(v);
    }

    @Override
    public final ValueNode numberNode(Integer v) {
        return this._nodeFactory.numberNode(v);
    }

    @Override
    public final ValueNode numberNode(Long v) {
        return this._nodeFactory.numberNode(v);
    }

    @Override
    public final ValueNode numberNode(Float v) {
        return this._nodeFactory.numberNode(v);
    }

    @Override
    public final ValueNode numberNode(Double v) {
        return this._nodeFactory.numberNode(v);
    }

    @Override
    public final StringNode stringNode(String text) {
        return this._nodeFactory.stringNode(text);
    }

    @Override
    public final BinaryNode binaryNode(byte[] data) {
        return this._nodeFactory.binaryNode(data);
    }

    @Override
    public final BinaryNode binaryNode(byte[] data, int offset, int length) {
        return this._nodeFactory.binaryNode(data, offset, length);
    }

    @Override
    public final ValueNode pojoNode(Object pojo) {
        return this._nodeFactory.pojoNode(pojo);
    }

    @Override
    public final ValueNode rawValueNode(RawValue value) {
        return this._nodeFactory.rawValueNode(value);
    }

    public abstract T removeAll();

    public abstract T removeIf(Predicate<? super JsonNode> var1);

    public T removeNulls() {
        return this.removeIf(JsonNode::isNull);
    }
}

