/*
 * Decompiled with CFR 0.152.
 */
package tools.fastlane.screengrab.locale;

import java.util.Locale;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import tools.fastlane.screengrab.Screengrab;
import tools.fastlane.screengrab.locale.LocaleListCompat;
import tools.fastlane.screengrab.locale.LocaleUtil;

public class LocaleTestRule
implements TestRule {
    private final Locale testLocale;
    private final String testLocaleString;

    public LocaleTestRule() {
        this(LocaleUtil.getTestLocale());
    }

    public LocaleTestRule(String testLocale) {
        this.testLocale = LocaleUtil.localeFromString(testLocale);
        this.testLocaleString = testLocale;
    }

    @Deprecated
    public LocaleTestRule(Locale testLocale) {
        StringBuilder sb = new StringBuilder(testLocale.getLanguage());
        String localeCountry = testLocale.getCountry();
        if (localeCountry.length() != 0) {
            sb.append("-").append(localeCountry);
        }
        this.testLocaleString = sb.toString();
        this.testLocale = testLocale;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                LocaleListCompat original = null;
                try {
                    if (LocaleTestRule.this.testLocale != null) {
                        original = LocaleUtil.changeDeviceLocaleTo(new LocaleListCompat(LocaleTestRule.this.testLocale));
                        Screengrab.setLocale(LocaleTestRule.this.testLocaleString);
                    }
                    base.evaluate();
                }
                finally {
                    if (original != null) {
                        LocaleUtil.changeDeviceLocaleTo(original);
                    }
                }
            }
        };
    }
}

