/*
 * Decompiled with CFR 0.152.
 */
package tools.fastlane.screengrab.locale;

import android.content.res.Configuration;
import android.os.Build;
import android.util.Log;
import androidx.test.platform.app.InstrumentationRegistry;
import java.lang.reflect.Method;
import java.util.Locale;

public final class LocaleUtil {
    private static final String TAG = LocaleUtil.class.getSimpleName();

    public static void changeDeviceLocaleTo(Locale locale) {
        if (locale == null) {
            Log.w((String)TAG, (String)"Skipping setting device locale to null");
            return;
        }
        Locale.setDefault(locale);
        try {
            Class<?> amnClass = Class.forName("android.app.ActivityManagerNative");
            Method methodGetDefault = amnClass.getMethod("getDefault", new Class[0]);
            methodGetDefault.setAccessible(true);
            Object activityManagerNative = methodGetDefault.invoke(amnClass, new Object[0]);
            if (Build.VERSION.SDK_INT >= 26) {
                amnClass = Class.forName(activityManagerNative.getClass().getName());
            }
            Method methodGetConfiguration = amnClass.getMethod("getConfiguration", new Class[0]);
            methodGetConfiguration.setAccessible(true);
            Configuration config = (Configuration)methodGetConfiguration.invoke(activityManagerNative, new Object[0]);
            config.getClass().getField("userSetLocale").setBoolean(config, true);
            config.locale = locale;
            config.setLayoutDirection(locale);
            Method updateConfigurationMethod = amnClass.getMethod("updateConfiguration", Configuration.class);
            updateConfigurationMethod.setAccessible(true);
            updateConfigurationMethod.invoke(activityManagerNative, config);
            Log.d((String)TAG, (String)("Locale changed to " + locale));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Failed to change device locale to " + locale), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String[] localePartsFrom(String localeString) {
        if (localeString == null) {
            return null;
        }
        String[] localeParts = localeString.split("_");
        if (localeParts.length < 1 || localeParts.length > 3) {
            return null;
        }
        return localeParts;
    }

    public static Locale localeFromParts(String[] localeParts) {
        if (localeParts == null || localeParts.length == 0) {
            return null;
        }
        if (localeParts.length == 1) {
            return new Locale(localeParts[0]);
        }
        if (localeParts.length == 2) {
            return new Locale(localeParts[0], localeParts[1]);
        }
        return new Locale(localeParts[0], localeParts[1], localeParts[2]);
    }

    public static Locale getTestLocale() {
        return LocaleUtil.localeFromInstrumentation("testLocale");
    }

    public static Locale getEndingLocale() {
        return LocaleUtil.localeFromInstrumentation("endingLocale");
    }

    private static Locale localeFromInstrumentation(String key) {
        String localeString = InstrumentationRegistry.getArguments().getString(key);
        return LocaleUtil.localeFromParts(LocaleUtil.localePartsFrom(localeString));
    }

    private LocaleUtil() {
    }
}

