/*
 * Decompiled with CFR 0.152.
 */
package tools.fastlane.screengrab.locale;

import java.util.Locale;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import tools.fastlane.screengrab.locale.LocaleUtil;

public class LocaleTestRule
implements TestRule {
    private final Locale testLocale;
    private final Locale endingLocale;

    public LocaleTestRule() {
        this(LocaleUtil.getTestLocale(), LocaleUtil.getEndingLocale());
    }

    public LocaleTestRule(Locale testLocale, Locale endingLocale) {
        this.testLocale = testLocale;
        this.endingLocale = endingLocale;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    if (LocaleTestRule.this.testLocale != null) {
                        LocaleUtil.changeDeviceLocaleTo(LocaleTestRule.this.testLocale);
                    }
                    base.evaluate();
                }
                finally {
                    if (LocaleTestRule.this.endingLocale != null) {
                        LocaleUtil.changeDeviceLocaleTo(LocaleTestRule.this.endingLocale);
                    }
                }
            }
        };
    }
}

