/*
 * Decompiled with CFR 0.152.
 */
package tools.fastlane.screengrab.file;

import android.annotation.TargetApi;
import java.io.File;
import java.io.IOException;

public abstract class Chmod {
    private static final Chmod INSTANCE = new Java6Chmod();

    public static void chmodPlusR(File file) {
        INSTANCE.plusR(file);
    }

    public static void chmodPlusRWX(File file) {
        INSTANCE.plusRWX(file);
    }

    protected abstract void plusR(File var1);

    protected abstract void plusRWX(File var1);

    private static class Java6Chmod
    extends Chmod {
        private Java6Chmod() {
        }

        @Override
        @TargetApi(value=9)
        protected void plusR(File file) {
            file.setReadable(true, false);
        }

        @Override
        @TargetApi(value=9)
        protected void plusRWX(File file) {
            file.setReadable(true, false);
            file.setWritable(true, false);
            file.setExecutable(true, false);
        }
    }

    private static class Java5Chmod
    extends Chmod {
        private Java5Chmod() {
        }

        @Override
        protected void plusR(File file) {
            try {
                Runtime.getRuntime().exec(new String[]{"chmod", "644", file.getAbsolutePath()});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void plusRWX(File file) {
            try {
                Runtime.getRuntime().exec(new String[]{"chmod", "777", file.getAbsolutePath()});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

