/*
 * Decompiled with CFR 0.152.
 */
package tools.fastlane.screengrab.cleanstatusbar;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.test.InstrumentationRegistry;
import tools.fastlane.screengrab.cleanstatusbar.BarsMode;
import tools.fastlane.screengrab.cleanstatusbar.BluetoothState;
import tools.fastlane.screengrab.cleanstatusbar.IconVisibility;
import tools.fastlane.screengrab.cleanstatusbar.MobileDataType;
import tools.fastlane.screengrab.cleanstatusbar.VolumeState;

public class CleanStatusBar {
    private static final String TAG = "Screengrab";
    private int batteryLevel = 100;
    private boolean batteryPlugged = false;
    private boolean batteryPowerSave = false;
    private IconVisibility airplaneModeVisibility = IconVisibility.HIDE;
    private boolean networkFullyConnected = true;
    private IconVisibility wifiVisibility = IconVisibility.SHOW;
    @Nullable
    private Integer wifiLevel = 4;
    private IconVisibility mobileNetworkVisibility = IconVisibility.SHOW;
    private MobileDataType mobileNetworkDataType = MobileDataType.HIDE;
    @Nullable
    private Integer mobileNetworkLevel = 4;
    private IconVisibility carrierNetworkChangeVisibility = IconVisibility.HIDE;
    private int numberOfSims = 1;
    private IconVisibility noSimVisibility = IconVisibility.HIDE;
    private BarsMode barsMode = BarsMode.TRANSPARENT;
    private VolumeState volumeState = VolumeState.HIDE;
    private BluetoothState bluetoothState = BluetoothState.HIDE;
    private IconVisibility locationVisibility = IconVisibility.HIDE;
    private IconVisibility alarmVisibility = IconVisibility.HIDE;
    private IconVisibility syncVisibility = IconVisibility.HIDE;
    private IconVisibility ttyVisibility = IconVisibility.HIDE;
    private IconVisibility eriVisibility = IconVisibility.HIDE;
    private IconVisibility muteVisibility = IconVisibility.HIDE;
    private IconVisibility speakerphoneVisibility = IconVisibility.HIDE;
    private boolean showNotifications = false;
    private String clock = "1230";

    public static void enableWithDefaults() {
        new CleanStatusBar().enable();
    }

    public static void disable() {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        CleanStatusBar.sendCommand(InstrumentationRegistry.getTargetContext(), "exit");
    }

    public CleanStatusBar setBatteryLevel(int batteryLevel) {
        if (batteryLevel < 0 || batteryLevel > 100) {
            throw new IllegalArgumentException("Battery level must be between 0 and 100");
        }
        this.batteryLevel = batteryLevel;
        return this;
    }

    public CleanStatusBar setBatteryPlugged(boolean batteryPlugged) {
        this.batteryPlugged = batteryPlugged;
        return this;
    }

    public CleanStatusBar setBatteryPowerSave(boolean batteryPowerSave) {
        this.batteryPowerSave = batteryPowerSave;
        return this;
    }

    public CleanStatusBar setAirplaneModeVisibility(@NonNull IconVisibility airplaneModeVisibility) {
        this.airplaneModeVisibility = airplaneModeVisibility;
        return this;
    }

    public CleanStatusBar setNetworkFullyConnected(boolean networkFullyConnected) {
        this.networkFullyConnected = networkFullyConnected;
        return this;
    }

    public CleanStatusBar setWifiVisibility(@NonNull IconVisibility wifiVisibility) {
        this.wifiVisibility = wifiVisibility;
        return this;
    }

    public CleanStatusBar setWifiLevel(@Nullable Integer wifiLevel) {
        if (wifiLevel != null && (wifiLevel < 0 || wifiLevel > 4)) {
            throw new IllegalArgumentException("Wifi level must be null or between 0 and 4");
        }
        this.wifiLevel = wifiLevel;
        return this;
    }

    public CleanStatusBar setMobileNetworkVisibility(@NonNull IconVisibility mobileNetworkVisibility) {
        this.mobileNetworkVisibility = mobileNetworkVisibility;
        return this;
    }

    public CleanStatusBar setMobileNetworkDataType(@NonNull MobileDataType mobileNetworkDataType) {
        this.mobileNetworkDataType = mobileNetworkDataType;
        return this;
    }

    public CleanStatusBar setMobileNetworkLevel(@Nullable Integer mobileNetworkLevel) {
        if (mobileNetworkLevel != null && (mobileNetworkLevel < 0 || mobileNetworkLevel > 4)) {
            throw new IllegalArgumentException("Mobile network level must be null or between 0 and 4");
        }
        this.mobileNetworkLevel = mobileNetworkLevel;
        return this;
    }

    public CleanStatusBar setCarrierNetworkChangeVisibility(@NonNull IconVisibility carrierNetworkChangeVisibility) {
        this.carrierNetworkChangeVisibility = carrierNetworkChangeVisibility;
        return this;
    }

    public CleanStatusBar setNumberOfSims(int numberOfSims) {
        if (numberOfSims < 1 || numberOfSims > 8) {
            throw new IllegalArgumentException("Number of sims must be between 1 and 8");
        }
        this.numberOfSims = numberOfSims;
        return this;
    }

    public CleanStatusBar setNoSimVisibility(@NonNull IconVisibility noSimVisibility) {
        this.noSimVisibility = noSimVisibility;
        return this;
    }

    public CleanStatusBar setBarsMode(@NonNull BarsMode barsMode) {
        this.barsMode = barsMode;
        return this;
    }

    public CleanStatusBar setVolumeState(@NonNull VolumeState volumeState) {
        this.volumeState = volumeState;
        return this;
    }

    public CleanStatusBar setBluetoothState(@NonNull BluetoothState bluetoothState) {
        this.bluetoothState = bluetoothState;
        return this;
    }

    public CleanStatusBar setLocationVisibility(@NonNull IconVisibility locationVisibility) {
        this.locationVisibility = locationVisibility;
        return this;
    }

    public CleanStatusBar setAlarmVisibility(@NonNull IconVisibility alarmVisibility) {
        this.alarmVisibility = alarmVisibility;
        return this;
    }

    public CleanStatusBar setSyncVisibility(@NonNull IconVisibility syncVisibility) {
        this.syncVisibility = syncVisibility;
        return this;
    }

    public CleanStatusBar setTtyVisibility(@NonNull IconVisibility ttyVisibility) {
        this.ttyVisibility = ttyVisibility;
        return this;
    }

    public CleanStatusBar setEriVisibility(@NonNull IconVisibility eriVisibility) {
        this.eriVisibility = eriVisibility;
        return this;
    }

    public CleanStatusBar setMuteVisibility(@NonNull IconVisibility muteVisibility) {
        this.muteVisibility = muteVisibility;
        return this;
    }

    public CleanStatusBar setSpeakerphoneVisibility(@NonNull IconVisibility speakerphoneVisibility) {
        this.speakerphoneVisibility = speakerphoneVisibility;
        return this;
    }

    public CleanStatusBar setShowNotifications(boolean showNotifications) {
        this.showNotifications = showNotifications;
        return this;
    }

    public CleanStatusBar setClock(@NonNull String clock) {
        if (!clock.matches("^[0-9]{4}$")) {
            throw new IllegalArgumentException("The clock must be a string of 4 integers");
        }
        this.clock = clock;
        return this;
    }

    public void enable() {
        if (Build.VERSION.SDK_INT < 23) {
            Log.w((String)TAG, (String)"Clean status bar is only supported on Android 6.0 and above");
            return;
        }
        Context context = InstrumentationRegistry.getTargetContext();
        CleanStatusBar.sendCommand(context, "battery", "level", Integer.toString(this.batteryLevel), "plugged", this.batteryPlugged ? "true" : "false", "powersave", this.batteryPowerSave ? "true" : "false");
        CleanStatusBar.sendCommand(context, "network", "wifi", this.wifiVisibility.getValue(), "level", this.wifiLevel == null ? "null" : Integer.toString(this.wifiLevel));
        CleanStatusBar.sendCommand(context, "network", "nosim", this.noSimVisibility.getValue());
        CleanStatusBar.sendCommand(context, "network", "airplane", this.airplaneModeVisibility.getValue());
        if (this.airplaneModeVisibility == IconVisibility.HIDE) {
            CleanStatusBar.sendCommand(context, "network", "sims", Integer.toString(this.numberOfSims));
            CleanStatusBar.sendCommand(context, "network", "carriernetworkchange", this.carrierNetworkChangeVisibility.getValue());
            if (this.carrierNetworkChangeVisibility == IconVisibility.HIDE) {
                CleanStatusBar.sendCommand(context, "network", "mobile", this.mobileNetworkVisibility.getValue(), "level", this.mobileNetworkLevel == null ? "null" : Integer.toString(this.mobileNetworkLevel), "datatype", this.mobileNetworkDataType.getValue());
            }
        }
        CleanStatusBar.sendCommand(context, "network", "fully", this.networkFullyConnected ? "true" : "false");
        CleanStatusBar.sendCommand(context, "bars", "mode", this.barsMode.getValue());
        CleanStatusBar.sendCommand(context, "status", "volume", this.volumeState.getValue());
        CleanStatusBar.sendCommand(context, "status", "bluetooth", this.bluetoothState.getValue());
        CleanStatusBar.sendCommand(context, "status", "location", this.locationVisibility.getValue());
        CleanStatusBar.sendCommand(context, "status", "alarm", this.alarmVisibility.getValue());
        CleanStatusBar.sendCommand(context, "status", "sync", this.syncVisibility.getValue());
        CleanStatusBar.sendCommand(context, "status", "tty", this.ttyVisibility.getValue());
        CleanStatusBar.sendCommand(context, "status", "eri", this.eriVisibility.getValue());
        CleanStatusBar.sendCommand(context, "status", "mute", this.muteVisibility.getValue());
        CleanStatusBar.sendCommand(context, "status", "speakerphone", this.speakerphoneVisibility.getValue());
        CleanStatusBar.sendCommand(context, "notifications", "visible", this.showNotifications ? "true" : "false");
        CleanStatusBar.sendCommand(context, "clock", "hhmm", this.clock);
    }

    private static void sendCommand(@NonNull Context context, String ... commands) {
        if ((commands.length - 1) % 2 != 0) {
            throw new IllegalArgumentException();
        }
        Intent intent = new Intent("com.android.systemui.demo").putExtra("command", commands[0]);
        for (int i = 1; i < commands.length; i += 2) {
            intent.putExtra(commands[i], commands[i + 1]);
        }
        context.sendBroadcast(intent);
    }
}

