/*
 * Decompiled with CFR 0.152.
 */
package tools.fastlane.screengrab;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.Log;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import tools.fastlane.screengrab.ScreenshotCallback;
import tools.fastlane.screengrab.file.Chmod;

public class FileWritingScreenshotCallback
implements ScreenshotCallback {
    private static final String TAG = "Screengrab";
    protected static final String NAME_SEPARATOR = "_";
    protected static final String EXTENSION = ".png";
    private static final int FULL_QUALITY = 100;
    private static final String SCREENGRAB_DIR_NAME = "screengrab";
    private static final String APPEND_TIMESTAMP_CONFIG_KEY = "appendTimestamp";
    private final Context appContext;

    public FileWritingScreenshotCallback(Context appContext) {
        this.appContext = appContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void screenshotCaptured(String screenshotName, Bitmap screenshot) {
        try {
            File screenshotDirectory = FileWritingScreenshotCallback.getFilesDirectory(this.appContext, Locale.getDefault());
            File screenshotFile = this.getScreenshotFile(screenshotDirectory, screenshotName);
            BufferedOutputStream fos = null;
            try {
                fos = new BufferedOutputStream(new FileOutputStream(screenshotFile));
                screenshot.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
                Chmod.chmodPlusR(screenshotFile);
            }
            finally {
                screenshot.recycle();
                if (fos != null) {
                    ((OutputStream)fos).close();
                }
            }
            Log.d((String)TAG, (String)("Captured screenshot \"" + screenshotFile.getName() + "\""));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to capture screenshot.", e);
        }
    }

    protected File getScreenshotFile(File screenshotDirectory, String screenshotName) {
        String screenshotFileName = screenshotName + (FileWritingScreenshotCallback.shouldAppendTimestamp() ? NAME_SEPARATOR + System.currentTimeMillis() : "") + EXTENSION;
        return new File(screenshotDirectory, screenshotFileName);
    }

    private static File getFilesDirectory(Context context, Locale locale) throws IOException {
        File internalDir;
        File directory = null;
        if (Build.VERSION.SDK_INT >= 21) {
            internalDir = new File(context.getFilesDir(), FileWritingScreenshotCallback.getDirectoryName(context, locale));
            directory = FileWritingScreenshotCallback.initializeDirectory(internalDir);
        }
        if (directory == null && Build.VERSION.SDK_INT < 24) {
            internalDir = new File(context.getDir(SCREENGRAB_DIR_NAME, 1), FileWritingScreenshotCallback.localeToDirName(locale));
            directory = FileWritingScreenshotCallback.initializeDirectory(internalDir);
        }
        if (directory == null) {
            throw new IOException("Unable to get a screenshot storage directory");
        }
        Log.d((String)TAG, (String)("Using screenshot storage directory: " + directory.getAbsolutePath()));
        return directory;
    }

    private static File initializeDirectory(File dir) {
        try {
            FileWritingScreenshotCallback.createPathTo(dir);
            if (dir.isDirectory() && dir.canWrite()) {
                return dir;
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Failed to initialize directory: " + dir.getAbsolutePath()), (Throwable)e);
        }
        return null;
    }

    private static String getDirectoryName(Context context, Locale locale) {
        return context.getPackageName() + "/" + SCREENGRAB_DIR_NAME + "/" + FileWritingScreenshotCallback.localeToDirName(locale);
    }

    private static String localeToDirName(Locale locale) {
        StringBuilder sb = new StringBuilder(locale.getLanguage());
        String localeCountry = locale.getCountry();
        if (localeCountry != null && localeCountry.length() != 0) {
            sb.append("-").append(localeCountry);
        }
        return sb.append("/images/screenshots").toString();
    }

    private static void createPathTo(File dir) throws IOException {
        File parent = dir.getParentFile();
        if (!parent.exists()) {
            FileWritingScreenshotCallback.createPathTo(parent);
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Unable to create output dir: " + dir.getAbsolutePath());
        }
        Chmod.chmodPlusRWX(dir);
    }

    private static boolean shouldAppendTimestamp() {
        return Boolean.parseBoolean(InstrumentationRegistry.getArguments().getString(APPEND_TIMESTAMP_CONFIG_KEY));
    }
}

