/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.lib.language;

import java.util.Collection;

public class LanguageUtils {
    public static <T extends Number> double calculateIC(Collection<T> values) {
        return LanguageUtils.calculateNormalisedIC(values) * (double)values.size();
    }

    public static <T extends Number> double calculateNormalisedIC(Iterable<T> values) {
        double expectedIC = 0.0;
        for (Number number : values) {
            expectedIC += number.doubleValue() * number.doubleValue();
        }
        return expectedIC / 10000.0;
    }
}

