/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.lib.parallel;

import tools.cipher.lib.parallel.MasterThread;

public class WorkerThread
extends Thread {
    private MasterThread master;
    private Runnable currentJob;
    private Exception error;

    public WorkerThread(MasterThread master, ThreadGroup threadGroup) {
        super(threadGroup, "worker-thread");
        this.master = master;
        this.error = null;
    }

    @Override
    public void run() {
        while (true) {
            this.currentJob = this.master.getJob();
            if (this.currentJob != null) {
                try {
                    this.currentJob.run();
                    continue;
                }
                catch (Exception e) {
                    this.error = e;
                }
                finally {
                    if (!this.hasError()) continue;
                    this.currentJob = null;
                    break;
                }
            }
            if (this.master.hasFinishedAddedJobs()) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean hasError() {
        return this.error != null;
    }

    public Exception getError() {
        return this.error;
    }

    public boolean hasJobRunning() {
        return this.currentJob != null;
    }
}

