/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.lib.result;

import com.alexbarter.lib.util.ArrayUtil;
import java.util.Arrays;
import tools.cipher.lib.fitness.NGramData;
import tools.cipher.lib.fitness.TextFitness;
import tools.cipher.lib.language.ILanguage;
import tools.cipher.lib.result.ResultNegative;

public class Solution
extends ResultNegative {
    public static final Solution WORST_SOLUTION = new Solution(new char[0], Double.NEGATIVE_INFINITY);
    private static final String UNKNOWN_KEY = "UNKNOWN";
    private char[] text;
    private boolean beenBaked;
    public String keyString;

    public Solution(char[] text, double score) {
        this(text, score, false);
    }

    public Solution(char[] text, double score, boolean immutable) {
        super(score);
        this.text = text;
        this.beenBaked = immutable;
        this.keyString = UNKNOWN_KEY;
    }

    public Solution(char[] text, ILanguage language, boolean immutable) {
        this(text, TextFitness.scoreFitnessQuadgrams(text, language), immutable);
    }

    public Solution(char[] text, NGramData nGramData, boolean immutable) {
        this(text, TextFitness.scoreFitness(text, nGramData), immutable);
    }

    public Solution(char[] text, ILanguage language) {
        this(text, TextFitness.scoreFitnessQuadgrams(text, language), false);
    }

    public Solution(char[] text, NGramData nGramData) {
        this(text, TextFitness.scoreFitness(text, nGramData), false);
    }

    public Solution setKeyString(String keyString) {
        this.keyString = keyString;
        return this;
    }

    public Solution setKeyString(String keyString, Object ... args) {
        return this.setKeyString(String.format(keyString, args));
    }

    public Solution bake() {
        if (!this.beenBaked) {
            this.beenBaked = true;
            this.text = ArrayUtil.copy((char[])this.text);
        }
        return this;
    }

    public int hashCode() {
        return Double.hashCode(this.score);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Solution other = (Solution)obj;
        if (Math.abs(this.score - other.score) > 0.4) {
            return false;
        }
        return Arrays.equals(this.text, other.text);
    }

    @Override
    public String toString() {
        return String.format("Fitness: %f, Key: %s, Plaintext: %s", this.score, this.keyString, new String(this.text));
    }

    public char[] getRaw() {
        return this.text;
    }

    public String getText() {
        return new String(this.text);
    }
}

