/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.lib.characters;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static final Pattern DIGIT_PATTERN = Pattern.compile("[0-9]");
    public static final Pattern LETTER_PATTERN = Pattern.compile("[a-zA-Z]");
    public static final Pattern SPACE_PATTERN = Pattern.compile("\\s");
    public static final Pattern OTHER_PATTERN = Pattern.compile("[^0-9a-zA-Z\\s]");

    public static String join(String delimiter, Object[] parts) {
        return StringUtils.join(delimiter, Objects::toString, parts);
    }

    public static <T> String join(String delimiter, Function<T, String> toString, T[] parts) {
        StringJoiner joiner = new StringJoiner(delimiter);
        for (T part : parts) {
            joiner.add(toString.apply(part));
        }
        return joiner.toString();
    }

    public static String reverseString(CharSequence target) {
        StringBuilder newString = new StringBuilder(target.length());
        for (int i = target.length() - 1; i >= 0; --i) {
            newString.append(target.charAt(i));
        }
        return newString.toString();
    }

    public static String getEveryNthChar(CharSequence text, int o, int n) {
        StringBuilder accumulator = new StringBuilder((int)Math.floor((double)text.length() / (double)n) + (text.length() % n > o ? 1 : 0));
        for (int i = o; i < text.length(); i += n) {
            accumulator.append(text.charAt(i));
        }
        return accumulator.toString();
    }

    public static String getEveryNthChar(char[] text, int start, int n) {
        StringBuilder accumulator = new StringBuilder((int)Math.floor((double)text.length / (double)n) + (text.length % n > start ? 1 : 0));
        for (int i = start; i < text.length; i += n) {
            accumulator.append(text[i]);
        }
        return accumulator.toString();
    }

    public static String getEveryNthBlock(String text, int entrySize, int start, int n) {
        int length = text.length() / entrySize;
        StringBuilder accumulator = new StringBuilder((int)Math.floor((double)length / (double)n) + (length % n > start ? 1 : 0));
        for (int i = start; i < text.length() / entrySize; i += n) {
            accumulator.append(text, i * entrySize, (i + 1) * entrySize);
        }
        return accumulator.toString();
    }

    public static String rotateRight(CharSequence text, int n) {
        StringBuilder newString = new StringBuilder(text.length());
        int cuttingPoint = text.length() - n % text.length();
        newString.append(text, cuttingPoint, text.length());
        newString.append(text, 0, cuttingPoint);
        return newString.toString();
    }

    public static String rotateLeft(CharSequence text, int n) {
        StringBuilder newString = new StringBuilder(text.length());
        int cuttingPoint = n % text.length();
        newString.append(text, cuttingPoint, text.length());
        newString.append(text, 0, cuttingPoint);
        return newString.toString();
    }

    public static String repeat(CharSequence repeat, int n) {
        StringBuilder total = new StringBuilder(repeat.length() * n);
        for (int i = 0; i < n; ++i) {
            total.append(repeat);
        }
        return total.toString();
    }

    public static String[] splitInto(String text, int size) {
        String[] list = new String[(int)Math.ceil((double)text.length() / (double)size)];
        int j = 0;
        for (int i = 0; i < text.length(); i += size) {
            list[j++] = text.subSequence(i, Math.min(i + size, text.length())).toString();
        }
        return list;
    }

    public static int countMatchingCharacters(CharSequence text, String regex) {
        return StringUtils.countMatchingCharacters(text, Pattern.compile(regex));
    }

    public static int countMatchingCharacters(CharSequence text, Pattern pattern) {
        Matcher matcher = pattern.matcher(text);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static int countDigitChars(String text) {
        return StringUtils.countMatchingCharacters((CharSequence)text, DIGIT_PATTERN);
    }

    public static int countLetterChars(String text) {
        return StringUtils.countMatchingCharacters((CharSequence)text, LETTER_PATTERN);
    }

    public static int countSpacesChars(String text) {
        return StringUtils.countMatchingCharacters((CharSequence)text, SPACE_PATTERN);
    }

    public static int countOtherChars(String text) {
        return StringUtils.countMatchingCharacters((CharSequence)text, OTHER_PATTERN);
    }

    public static Set<Character> getUniqueCharSet(CharSequence inputText) {
        HashSet<Character> set = new HashSet<Character>();
        for (int i = 0; i < inputText.length(); ++i) {
            set.add(Character.valueOf(inputText.charAt(i)));
        }
        return set;
    }

    public static boolean isContentEqual(CharSequence expected, CharSequence actual) {
        if (expected.length() != actual.length()) {
            return false;
        }
        for (int i = 0; i < expected.length(); ++i) {
            if (expected.charAt(i) == actual.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

