/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.lib.registry;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IRegistry<K, T> {
    public boolean register(@Nonnull K var1, T var2);

    default public void registerAll(T ... values) {
        for (T value : values) {
            this.register(value);
        }
    }

    default public boolean register(T value) {
        return this.register(this.getNamingScheme().getKey(this, value), value);
    }

    public boolean remove(K var1);

    public INamingScheme<K, T> getNamingScheme();

    public String getRegistryName();

    public T get(K var1);

    public Stream<K> getKeys(T var1);

    default public Optional<K> getKey(T value) {
        return this.getKeys(value).findFirst();
    }

    default public Optional<T> getWrapped(K key) {
        return Optional.ofNullable(this.get(key));
    }

    public boolean contains(@Nonnull K var1);

    public int size();

    public boolean isEmpty();

    @Nullable
    public Class<K> getKeyType();

    @Nullable
    public Class<T> getType();

    @Nonnull
    public Collection<K> getKeys();

    @Nonnull
    public Collection<T> getValues();

    @Nonnull
    public Collection<Map.Entry<K, T>> getEntries();

    public void freeze();

    public boolean frozen();

    default public void accept(K key, Consumer<T> fun) {
        this.getWrapped(key).ifPresent(v -> fun.accept(v));
    }

    default public <R> Optional<R> apply(K key, Function<T, R> fun) {
        return this.getWrapped(key).map(fun);
    }

    default public <R> Stream<R> mapValues(Function<T, R> fun) {
        return this.getValues().stream().map(fun);
    }

    default public <R> Map<R, T> getMap(Function<T, R> fun) {
        return this.getValues().stream().collect(Collectors.toMap(fun, Function.identity()));
    }

    public static interface INamingScheme<K, T> {
        @Nonnull
        public K getKey(IRegistry<K, T> var1, T var2);
    }
}

