/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.lib.characters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CharacterCount {
    private static Comparator<Map.Entry<Character, Integer>> LETTER_COUNT_COMPARATOR = (o1, o2) -> {
        int comp = Integer.compare((Integer)o2.getValue(), (Integer)o1.getValue());
        return comp == 0 ? Character.compare(((Character)o1.getKey()).charValue(), ((Character)o2.getKey()).charValue()) : comp;
    };

    public static Map<String, Integer> getCount(CharSequence text, int minLength, int maxLength) {
        return CharacterCount.getCount(text, minLength, maxLength, true);
    }

    public static Map<String, Integer> getCount(CharSequence text, int minLength, int maxLength, boolean overlap) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (text.length() >= minLength) {
            for (int length = minLength; length <= maxLength; ++length) {
                for (int k = 0; k < text.length() - length + 1; k += overlap ? 1 : length) {
                    String s = text.subSequence(k, k + length).toString();
                    map.put(s, map.getOrDefault(s, 0) + 1);
                }
            }
        }
        return map;
    }

    public static Map<Character, Integer> getCount(CharSequence text) {
        HashMap<Character, Integer> map = new HashMap<Character, Integer>();
        for (int k = 0; k < text.length(); ++k) {
            map.put(Character.valueOf(text.charAt(k)), map.getOrDefault(Character.valueOf(text.charAt(k)), 0) + 1);
        }
        return map;
    }

    public static Map<Character, Integer> getCount(char[] text) {
        HashMap<Character, Integer> map = new HashMap<Character, Integer>();
        for (int k = 0; k < text.length; ++k) {
            map.put(Character.valueOf(text[k]), map.getOrDefault(Character.valueOf(text[k]), 0) + 1);
        }
        return map;
    }

    public static List<Character> getOrderedCharacters(char[] text) {
        return CharacterCount.getOrderedCharacter(CharacterCount.getOrderedEntries(CharacterCount.getCount(text)));
    }

    public static List<Character> getOrderedCharacters(CharSequence text) {
        return CharacterCount.getOrderedCharacter(CharacterCount.getOrderedEntries(CharacterCount.getCount(text)));
    }

    private static List<Map.Entry<Character, Integer>> getOrderedEntries(Map<Character, Integer> map) {
        ArrayList<Map.Entry<Character, Integer>> list = new ArrayList<Map.Entry<Character, Integer>>(map.entrySet());
        Collections.sort(list, LETTER_COUNT_COMPARATOR);
        return list;
    }

    private static List<Character> getOrderedCharacter(List<Map.Entry<Character, Integer>> orderedEntries) {
        ArrayList<Character> list = new ArrayList<Character>(orderedEntries.size());
        for (int i = 0; i < orderedEntries.size(); ++i) {
            list.add(orderedEntries.get(i).getKey());
        }
        return list;
    }
}

