/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.lib;

public class NumberString {
    private static final String[] specialNames = new String[]{"", "THOUSAND", "MILLION", "BILLION", "TRILLION", "QUADRILLION", "QUINTILLION"};
    private static final String[] tensNames = new String[]{"", "TEN", "TWENTY", "THIRTY", "FORTY", "FIFTY", "SIXTY", "SEVENTY", "EIGHTY", "NINTY"};
    private static final String[] numNames = new String[]{"", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE", "TEN", "ELEVEN", "TWELVE", "THIRTEEN", "FOURTEEN", "FIFTEEN", "SIXTEEN", "SEVENTEEN", "EIGHTEEN", "NINETEEN"};

    private static String convertLessThanOneThousand(int number) {
        String current;
        if (number % 100 < 20) {
            current = numNames[number % 100];
            number /= 100;
        } else {
            current = numNames[number % 10];
            current = tensNames[(number /= 10) % 10] + current;
            number /= 10;
        }
        if (number == 0) {
            return current;
        }
        return numNames[number] + "HUNDRED" + current;
    }

    public static String convert(int number) {
        if (number == 0) {
            return "ZERO";
        }
        String current = "";
        int place = 0;
        do {
            int n;
            if ((n = number % 1000) != 0) {
                String s = NumberString.convertLessThanOneThousand(n);
                current = s + specialNames[place] + current;
            }
            ++place;
        } while ((number /= 1000) > 0);
        return current;
    }
}

