/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClassDiscoverer {
    private static List<String> classCache;
    private static Function<String, Optional<String>> GET_CLASS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<String> getClassesInPackage(@Nonnull String basePackage) {
        if (classCache == null) {
            String[] classPathEntries;
            String path = basePackage.replace('.', File.separatorChar);
            ArrayList<String> classes = new ArrayList<String>();
            for (String classpathEntry : classPathEntries = System.getProperty("java.class.path").split(System.getProperty("path.separator"))) {
                if (classpathEntry.endsWith(".jar")) {
                    File jar = new File(classpathEntry);
                    ZipInputStream is = null;
                    try {
                        JarEntry entry;
                        is = new JarInputStream(new FileInputStream(jar));
                        while ((entry = ((JarInputStream)is).getNextJarEntry()) != null) {
                            String name = entry.getName();
                            if (!name.startsWith(path)) continue;
                            GET_CLASS.apply(name).ifPresent(classes::add);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    finally {
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
                try {
                    File base = new File(classpathEntry + File.separatorChar + path);
                    ClassDiscoverer.traverseDirectory(base, basePackage, (file, packageName) -> GET_CLASS.apply(packageName + '.' + file.getName()).ifPresent(classes::add));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            classCache = classes;
        }
        return classCache;
    }

    private static void traverseDirectory(File dir, String packageName, BiConsumer<File, String> consumer) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                ClassDiscoverer.traverseDirectory(file, (!packageName.isEmpty() ? packageName + '.' : "") + file.getName(), consumer);
                continue;
            }
            if (!file.isFile()) continue;
            consumer.accept(file, packageName);
        }
    }

    public static <T> List<T> getInstances(String basePackage, @Nullable Class<? extends Annotation> annotationClass, Class<T> instanceClass) {
        ArrayList<T> instances = new ArrayList<T>();
        List<String> classes = ClassDiscoverer.getClassesInPackage(basePackage);
        for (String className : classes) {
            try {
                Class<?> asmClass = Class.forName(className);
                if (annotationClass != null && !asmClass.isAnnotationPresent(annotationClass) || !instanceClass.isAssignableFrom(asmClass) || instanceClass == asmClass) continue;
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                T instance = asmInstanceClass.newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError e) {
                System.err.println("Failed to load: " + className + " " + e);
            }
        }
        return instances;
    }

    static {
        GET_CLASS = name -> {
            String clazz = null;
            if (name.endsWith(".class")) {
                String classPath = name.substring(0, name.length() - 6);
                clazz = classPath.replaceAll("[\\|/]", ".");
            }
            return Optional.ofNullable(clazz);
        };
    }
}

