/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.identify;

import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.identify.CipherStatistics;
import com.alexbarter.ciphertool.identify.IdentifyOutput;
import com.alexbarter.ciphertool.identify.TextStatistic;
import com.alexbarter.ciphertool.identify.holder.DataHolder;
import com.alexbarter.ciphertool.identify.type.StatisticBifid0;
import com.alexbarter.ciphertool.identify.type.StatisticDiagrahpicICx10000;
import com.alexbarter.ciphertool.identify.type.StatisticDoubleLetter;
import com.alexbarter.ciphertool.identify.type.StatisticDoubleLetter2to40;
import com.alexbarter.ciphertool.identify.type.StatisticEvenDiagrahpicICx10000;
import com.alexbarter.ciphertool.identify.type.StatisticICx1000;
import com.alexbarter.ciphertool.identify.type.StatisticKappaICx1000;
import com.alexbarter.ciphertool.identify.type.StatisticLogDigraph;
import com.alexbarter.ciphertool.identify.type.StatisticLogDigraphAffine;
import com.alexbarter.ciphertool.identify.type.StatisticLogDigraphAutokeyBeaufort;
import com.alexbarter.ciphertool.identify.type.StatisticLogDigraphAutokeyPorta;
import com.alexbarter.ciphertool.identify.type.StatisticLogDigraphAutokeyVariant;
import com.alexbarter.ciphertool.identify.type.StatisticLogDigraphAutokeyVigenere;
import com.alexbarter.ciphertool.identify.type.StatisticLogDigraphBeaufort;
import com.alexbarter.ciphertool.identify.type.StatisticLogDigraphCaesar;
import com.alexbarter.ciphertool.identify.type.StatisticLogDigraphPorta;
import com.alexbarter.ciphertool.identify.type.StatisticLogDigraphPortax;
import com.alexbarter.ciphertool.identify.type.StatisticLogDigraphReversed;
import com.alexbarter.ciphertool.identify.type.StatisticLogDigraphSlidefairBeaufort;
import com.alexbarter.ciphertool.identify.type.StatisticLogDigraphSlidefairVariant;
import com.alexbarter.ciphertool.identify.type.StatisticLogDigraphSlidefairVigenere;
import com.alexbarter.ciphertool.identify.type.StatisticLogDigraphVariant;
import com.alexbarter.ciphertool.identify.type.StatisticLogDigraphVigenere;
import com.alexbarter.ciphertool.identify.type.StatisticLongRepeat;
import com.alexbarter.ciphertool.identify.type.StatisticMaxBifid3to15;
import com.alexbarter.ciphertool.identify.type.StatisticMaxICx1000;
import com.alexbarter.ciphertool.identify.type.StatisticMaxNicodemus3to15;
import com.alexbarter.ciphertool.identify.type.StatisticMaxTrifid3to15;
import com.alexbarter.ciphertool.identify.type.StatisticMaxUniqueCharacters;
import com.alexbarter.ciphertool.identify.type.StatisticNormalOrder;
import com.alexbarter.ciphertool.identify.type.StatisticPercentageOddRepeats;
import com.alexbarter.ciphertool.identify.type.StatisticTextLengthMultiple;
import com.alexbarter.ciphertool.identify.type.StatisticTrigraphNoOverlapICx100000;
import com.alexbarter.ciphertool.lib.file.FileReader;
import com.alexbarter.ciphertool.lib.math.Statistics;
import com.alexbarter.ciphertool.lib.registry.IRegistry;
import com.alexbarter.ciphertool.lib.registry.Registry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.JProgressBar;

public class StatisticRegistry {
    public static final IRegistry<String, Function<String, TextStatistic<?>>> TEXT_STATISTIC_MAP = Registry.builder().setRegistryName("TextStatistic").build();
    public static final IRegistry<String, String> DISPLAY_NAME_MAP = Registry.builder(String.class).setRegistryName("StatisticDisplayName").build();

    public static boolean registerStatistic(String id, Function<String, TextStatistic<?>> textStatistic) {
        return StatisticRegistry.registerStatistic(id, textStatistic, id);
    }

    public static boolean registerStatistic(String id, Function<String, TextStatistic<?>> textStatistic, String shortName) {
        if (TEXT_STATISTIC_MAP.register((Object)id, textStatistic)) {
            if (DISPLAY_NAME_MAP.register((Object)id, (Object)shortName)) {
                return true;
            }
            TEXT_STATISTIC_MAP.remove((Object)id);
        }
        return false;
    }

    public static List<IdentifyOutput> orderCipherProbability(String text) {
        return StatisticRegistry.orderCipherProbability(StatisticRegistry.createTextStatistics(text));
    }

    public static List<IdentifyOutput> orderCipherProbability(HashMap<String, TextStatistic<?>> stats) {
        return StatisticRegistry.orderCipherProbability(stats, TEXT_STATISTIC_MAP.getKeys());
    }

    public static List<IdentifyOutput> orderCipherProbability(HashMap<String, TextStatistic<?>> stats, Collection<String> doOnly) {
        ArrayList<IdentifyOutput> computedResult = new ArrayList<IdentifyOutput>();
        Map<String, Object> statistic = CipherStatistics.getOtherCipherStatistics();
        StatisticRegistry.traverseDataTree(stats, doOnly, computedResult, new ArrayList<String>(), statistic);
        return computedResult;
    }

    public static void traverseDataTree(Map<String, TextStatistic<?>> stats, Collection<String> doOnly, List<IdentifyOutput> computedResult, Collection<String> keyBefore, Map<String, Object> toCheck) {
        for (String key : toCheck.keySet()) {
            Map nextBranch = (Map)toCheck.get(key);
            ArrayList<String> copy = new ArrayList<String>(keyBefore);
            copy.add(key);
            boolean type = false;
            Iterator iterator = nextBranch.values().iterator();
            if (iterator.hasNext()) {
                Object value = iterator.next();
                type = value instanceof DataHolder;
            }
            if (type) {
                double value = StatisticRegistry.scoreCipher(stats, nextBranch, doOnly);
                List<IdentifyOutput> last = computedResult;
                for (int i = 0; i < copy.size(); ++i) {
                    IdentifyOutput identifyOutput;
                    int index = StatisticRegistry.indexOf((String)copy.get(i), last);
                    if (index != -1) {
                        IdentifyOutput old = last.get(index);
                        identifyOutput = new IdentifyOutput(old.id, Math.min(old.score, value));
                        identifyOutput.subOutput.addAll(old.subOutput);
                        old.subOutput.clear();
                        last.set(index, identifyOutput);
                    } else {
                        identifyOutput = new IdentifyOutput((String)copy.get(i), value);
                        last.add(identifyOutput);
                    }
                    last = identifyOutput.subOutput;
                }
                continue;
            }
            StatisticRegistry.traverseDataTree(stats, doOnly, computedResult, copy, nextBranch);
        }
    }

    public static int indexOf(String key, List<IdentifyOutput> computedResult) {
        for (int i = 0; i < computedResult.size(); ++i) {
            if (!computedResult.get((int)i).id.equals(key)) continue;
            return i;
        }
        return -1;
    }

    public static double scoreCipher(Map<String, TextStatistic<?>> stats, Map<String, DataHolder> data, Collection<String> doOnly) {
        double value = 0.0;
        for (String id : data.keySet()) {
            if (!doOnly.contains(id)) continue;
            value += stats.get(id).quantify(data.get(id));
        }
        return value;
    }

    public static HashMap<String, TextStatistic<?>> createTextStatistics(String text) {
        return StatisticRegistry.createTextStatistics(text, null);
    }

    public static HashMap<String, TextStatistic<?>> createTextStatistics(String text, JProgressBar value) {
        HashMap stats = new HashMap();
        if (value != null) {
            value.setMaximum(TEXT_STATISTIC_MAP.size());
        }
        for (Map.Entry entry : TEXT_STATISTIC_MAP.getEntries()) {
            if (value != null) {
                value.setString((String)DISPLAY_NAME_MAP.get(entry.getKey()));
            }
            TextStatistic stat = (TextStatistic)((Function)entry.getValue()).apply(text);
            stats.put((String)entry.getKey(), stat.calculateStatistic());
            if (value == null) continue;
            value.setValue(value.getValue() + 1);
        }
        return stats;
    }

    public static void calculateStatPrint(ICipher<?> cipher, Function<String, TextStatistic<?>> textStatistic, int times) {
        ArrayList values = new ArrayList();
        try {
            FileReader.read((String)"/plainText.txt", line -> {
                String plainText = line;
                for (int i = 0; i < times; ++i) {
                    TextStatistic test = (TextStatistic)textStatistic.apply(cipher.randomEncode(plainText));
                    test.calculateStatistic();
                    try {
                        if (!(test.value instanceof Number)) continue;
                        values.add(((Number)test.value).doubleValue());
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Statistics stats = new Statistics(values);
        String name = cipher.getClass().getSimpleName();
        String variableName = "";
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            variableName = variableName + "_";
        }
        for (char c : name.toCharArray()) {
            variableName = !Character.isJavaIdentifierPart(c) ? variableName + "_" : variableName + c;
        }
        System.out.println(variableName + ".put(" + textStatistic.getClass().getSimpleName() + ", new DataHolder(" + String.format("%.2f", stats.getMean()) + ", " + String.format("%.2f", stats.getStandardDeviation()) + ")); //Min: " + String.format("%.2f", stats.getMin()) + " Max: " + String.format("%.2f", stats.getMax()));
    }

    public static void registerStatistics() {
        StatisticRegistry.registerStatistic("ic_1_x10000", StatisticICx1000::new, "IC");
        StatisticRegistry.registerStatistic("ic_max_x1000", StatisticMaxICx1000::new, "MIC");
        StatisticRegistry.registerStatistic("ic_2_true_x10000", StatisticDiagrahpicICx10000::new, "DIC");
        StatisticRegistry.registerStatistic("ic_2_false_x10000", StatisticEvenDiagrahpicICx10000::new, "DIC_E");
        StatisticRegistry.registerStatistic("ic_3_false_x100000", StatisticTrigraphNoOverlapICx100000::new, "TIC_E");
        StatisticRegistry.registerStatistic("ic_kappa_x1000", StatisticKappaICx1000::new, "MKA");
        StatisticRegistry.registerStatistic("log_digraph", StatisticLogDigraph::new, "LDI");
        StatisticRegistry.registerStatistic("log_digraph_reversed", StatisticLogDigraphReversed::new, "LDI_R");
        StatisticRegistry.registerStatistic("long_repeat", StatisticLongRepeat::new, "LR");
        StatisticRegistry.registerStatistic("long_repeat_odd_percentage", StatisticPercentageOddRepeats::new, "LR_OP");
        StatisticRegistry.registerStatistic("normal_order", StatisticNormalOrder::new, "NOR");
        StatisticRegistry.registerStatistic("double_letter_even", StatisticDoubleLetter::new, "DBL_PLAY");
        StatisticRegistry.registerStatistic("double_letter_even_2to40", StatisticDoubleLetter2to40::new, "DBL_SERP");
        StatisticRegistry.registerStatistic("max_unique_characters", StatisticMaxUniqueCharacters::new, "MAX_UNIQUE");
        StatisticRegistry.registerStatistic("text_length_multiple", StatisticTextLengthMultiple::new, "DIV_N");
        StatisticRegistry.registerStatistic("bifid_max_3to15", StatisticMaxBifid3to15::new, "BIC");
        StatisticRegistry.registerStatistic("bifid_0", StatisticBifid0::new, "BIC_Z");
        StatisticRegistry.registerStatistic("nicodemus_max_3to15", StatisticMaxNicodemus3to15::new, "NIC");
        StatisticRegistry.registerStatistic("trifid_max_3to15", StatisticMaxTrifid3to15::new, "TIC");
        StatisticRegistry.registerStatistic("log_digraph_caesar", StatisticLogDigraphCaesar::new, "LDI_CAE");
        StatisticRegistry.registerStatistic("log_digraph_affine", StatisticLogDigraphAffine::new, "LDI_AFF");
        StatisticRegistry.registerStatistic("log_digraph_beaufort", StatisticLogDigraphBeaufort::new, "LDI_BEU");
        StatisticRegistry.registerStatistic("log_digraph_porta", StatisticLogDigraphPorta::new, "LDI_POR");
        StatisticRegistry.registerStatistic("log_digraph_portax", StatisticLogDigraphPortax::new, "LDI_PTX");
        StatisticRegistry.registerStatistic("log_digraph_variant", StatisticLogDigraphVariant::new, "LDI_VAR");
        StatisticRegistry.registerStatistic("log_digraph_vigenere", StatisticLogDigraphVigenere::new, "LDI_VIG");
        StatisticRegistry.registerStatistic("log_digraph_autokey_beaufort", StatisticLogDigraphAutokeyBeaufort::new, "LDI_A_BEU");
        StatisticRegistry.registerStatistic("log_digraph_autokey_porta", StatisticLogDigraphAutokeyPorta::new, "LDI_A_POR");
        StatisticRegistry.registerStatistic("log_digraph_autokey_variant", StatisticLogDigraphAutokeyVariant::new, "LDI_A_VAR");
        StatisticRegistry.registerStatistic("log_digraph_autokey_vignere", StatisticLogDigraphAutokeyVigenere::new, "LDI_A_VIG");
        StatisticRegistry.registerStatistic("log_digraph_slidefair_beaufort", StatisticLogDigraphSlidefairBeaufort::new, "LDI_SLI_BEU");
        StatisticRegistry.registerStatistic("log_digraph_slidefair_variant", StatisticLogDigraphSlidefairVariant::new, "LDI_SLI_VAR");
        StatisticRegistry.registerStatistic("log_digraph_slidefair_vigenere", StatisticLogDigraphSlidefairVigenere::new, "LDI_SLI_VIG");
    }
}

