/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.solve;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import tools.cipher.base.interfaces.ICipher;
import tools.cipher.base.interfaces.ICipherProgram;
import tools.cipher.base.interfaces.IDecryptionTracker;
import tools.cipher.base.solve.CipherAttack;
import tools.cipher.base.solve.DecryptionMethod;
import tools.cipher.base.solve.DecryptionTracker;
import tools.cipher.ciphers.KeywordCipher;
import tools.cipher.ciphers.StraddleCheckerboardCipher;
import tools.cipher.lib.characters.CharArrayWrapper;
import tools.cipher.lib.characters.CharacterCount;

public class StraddleCheckerboardAttack
extends CipherAttack<String, StraddleCheckerboardCipher> {
    public StraddleCheckerboardAttack() {
        super(null, "Straddle Checkerboard");
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.CALCULATED});
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        switch (method) {
            case CALCULATED: {
                DecryptionTracker tracker = new DecryptionTracker(text, app);
                List counts = CharacterCount.getOrderedCharacters((CharSequence)tracker.getCipherText());
                this.output((IDecryptionTracker)tracker, "Spare positions: %c %c", new Object[]{counts.get(0), counts.get(1)});
                char first = ((Character)counts.get(0)).charValue();
                char second = ((Character)counts.get(1)).charValue();
                ArrayList<String> split = new ArrayList<String>();
                for (int i = 0; i < tracker.getLength(); ++i) {
                    if (tracker.getCipherText().charAt(i) == first || tracker.getCipherText().charAt(i) == second) {
                        split.add(tracker.getCipherText().charAt(i) + "" + tracker.getCipherText().charAt(i + 1));
                        ++i;
                        continue;
                    }
                    split.add("" + tracker.getCipherText().charAt(i));
                }
                app.out().println("" + split);
                char[] tempText = new char[split.size()];
                HashSet nonDupList = new HashSet(split);
                int t = 0;
                for (String nonDup : nonDupList) {
                    for (int i = 0; i < split.size(); ++i) {
                        if (!((String)split.get(i)).equals(nonDup)) continue;
                        tempText[i] = (char)(65 + t);
                    }
                    ++t;
                }
                CipherAttack substitutionHack = new CipherAttack((ICipher)new KeywordCipher("ABCDEFGHIJKLMNOPQRSTUVWXYZ"), "Straddle Checkerboard Sub").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}).setIterations(10);
                IDecryptionTracker keywordTracker = substitutionHack.attemptAttack((CharSequence)new CharArrayWrapper(tempText), DecryptionMethod.SIMULATED_ANNEALING, app);
                this.updateIfBetterThanBest((IDecryptionTracker)tracker, keywordTracker.getBestSolution());
                keywordTracker.getProgress().reset();
                return tracker;
            }
        }
        return super.attemptAttack(text, method, app);
    }
}

