/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers.registry;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import tools.cipher.base.interfaces.ICipher;
import tools.cipher.ciphers.ADFGXCipher;
import tools.cipher.ciphers.AMSCOCipher;
import tools.cipher.ciphers.AffineCipher;
import tools.cipher.ciphers.AutokeyCipher;
import tools.cipher.ciphers.BazeriesCipher;
import tools.cipher.ciphers.BifidCipher;
import tools.cipher.ciphers.CadenusCipher;
import tools.cipher.ciphers.CaesarCipher;
import tools.cipher.ciphers.ColumnarTranspositionCipher;
import tools.cipher.ciphers.ConjugatedBifidCipher;
import tools.cipher.ciphers.DigrafidCipher;
import tools.cipher.ciphers.DoubleColumnarTranspositionCipher;
import tools.cipher.ciphers.EnigmaPlugboardCipher;
import tools.cipher.ciphers.FourSquareCipher;
import tools.cipher.ciphers.FractionatedMorseCipher;
import tools.cipher.ciphers.GrilleCipher;
import tools.cipher.ciphers.HillCipher;
import tools.cipher.ciphers.HillExtendedCipher;
import tools.cipher.ciphers.HillSubstitutionCipher;
import tools.cipher.ciphers.HomophonicCipher;
import tools.cipher.ciphers.HuttonCipher;
import tools.cipher.ciphers.KeywordCipher;
import tools.cipher.ciphers.MorbitCipher;
import tools.cipher.ciphers.MyszkowskiCipher;
import tools.cipher.ciphers.NicodemusCipher;
import tools.cipher.ciphers.NihilistSubstitutionCipher;
import tools.cipher.ciphers.NihilistTranspositionCipher;
import tools.cipher.ciphers.PeriodicGromarkCipher;
import tools.cipher.ciphers.PhillipsCipher;
import tools.cipher.ciphers.PlayfairCipher;
import tools.cipher.ciphers.PolluxCipher;
import tools.cipher.ciphers.PortaxCipher;
import tools.cipher.ciphers.ProgressiveCipher;
import tools.cipher.ciphers.QuagmireICipher;
import tools.cipher.ciphers.QuagmireIICipher;
import tools.cipher.ciphers.QuagmireIIICipher;
import tools.cipher.ciphers.QuagmireIVCipher;
import tools.cipher.ciphers.RagbabyCipher;
import tools.cipher.ciphers.RailFenceCipher;
import tools.cipher.ciphers.RedefenceCipher;
import tools.cipher.ciphers.RouteTranspositionCipher;
import tools.cipher.ciphers.RunningKeyCipher;
import tools.cipher.ciphers.SeriatedPlayfairCipher;
import tools.cipher.ciphers.SlidefairCipher;
import tools.cipher.ciphers.SolitaireCipher;
import tools.cipher.ciphers.SwagmanCipher;
import tools.cipher.ciphers.TriSquareCipher;
import tools.cipher.ciphers.TrifidCipher;
import tools.cipher.ciphers.TwoSquareCipher;
import tools.cipher.ciphers.VigenereCipher;
import tools.cipher.ciphers.enigma.EnigmaLib;
import tools.cipher.lib.registry.IRegistry;
import tools.cipher.lib.registry.Registry;
import tools.cipher.util.VigenereType;

public class EncrypterRegistry {
    public static IRegistry<String, ICipher> RAND_ENCRYPTERS = Registry.builder(ICipher.class).setNamingScheme(cipher -> cipher.getClass().getSimpleName().toLowerCase(Locale.UK).replace("cipher", "")).build();
    private static Random RAND = new Random();

    public static ICipher<?> getFromName(String key) {
        return (ICipher)RAND_ENCRYPTERS.get((Object)key);
    }

    public static int getDifficulty(String name) {
        return RAND_ENCRYPTERS.apply((Object)name, ICipher::getDifficulty).orElse(ICipher.Difficulty.EASY).getLevel();
    }

    @Nullable
    public static ICipher<?> getEncrypterWith(int maxDifficulty) {
        return RAND_ENCRYPTERS.getValues().stream().filter(v -> v.getDifficulty().isEasierThan(maxDifficulty)).sorted((o1, o2) -> RAND.nextBoolean() ? 1 : -1).findAny().orElse(null);
    }

    public static void registerAll() {
        if (RAND_ENCRYPTERS.frozen()) {
            return;
        }
        RAND_ENCRYPTERS.register((Object)new ADFGXCipher());
        RAND_ENCRYPTERS.register((Object)"adfgvx", (Object)new ADFGXCipher("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789", "ADFGVX"));
        RAND_ENCRYPTERS.registerAll((Object[])new ICipher[]{new AffineCipher(), new AMSCOCipher()});
        RAND_ENCRYPTERS.register((Object)new BazeriesCipher());
        RAND_ENCRYPTERS.register((Object)new BifidCipher());
        RAND_ENCRYPTERS.register((Object)new CaesarCipher());
        RAND_ENCRYPTERS.register((Object)new CadenusCipher());
        RAND_ENCRYPTERS.register((Object)new ColumnarTranspositionCipher());
        RAND_ENCRYPTERS.register((Object)new DoubleColumnarTranspositionCipher());
        RAND_ENCRYPTERS.register((Object)new ConjugatedBifidCipher());
        RAND_ENCRYPTERS.register((Object)new DigrafidCipher());
        RAND_ENCRYPTERS.register((Object)new FourSquareCipher());
        RAND_ENCRYPTERS.register((Object)new FractionatedMorseCipher());
        RAND_ENCRYPTERS.register((Object)new HomophonicCipher());
        RAND_ENCRYPTERS.register((Object)new KeywordCipher());
        RAND_ENCRYPTERS.register((Object)new MorbitCipher());
        RAND_ENCRYPTERS.register((Object)new MyszkowskiCipher());
        for (VigenereType type : VigenereType.NORMAL_LIST) {
            String name = type.getClass().getSimpleName().toLowerCase();
            RAND_ENCRYPTERS.register((Object)(name + "_auto_key"), (Object)new AutokeyCipher(type));
            RAND_ENCRYPTERS.register((Object)(name + "_nicodemus"), (Object)new NicodemusCipher(type));
            RAND_ENCRYPTERS.register((Object)(name + "_progressive_key"), (Object)new ProgressiveCipher(type));
            RAND_ENCRYPTERS.register((Object)name, (Object)new VigenereCipher(type));
        }
        for (VigenereType type : VigenereType.SLIDEFAIR_LIST) {
            RAND_ENCRYPTERS.register((Object)(type.getClass().getSimpleName().toLowerCase() + "_slidefair"), (Object)new SlidefairCipher(type));
        }
        RAND_ENCRYPTERS.register((Object)new NihilistSubstitutionCipher());
        RAND_ENCRYPTERS.register((Object)new NihilistTranspositionCipher());
        RAND_ENCRYPTERS.register((Object)new PeriodicGromarkCipher());
        RAND_ENCRYPTERS.register((Object)new PhillipsCipher());
        RAND_ENCRYPTERS.register((Object)new PlayfairCipher());
        RAND_ENCRYPTERS.register((Object)"playfair6x6cipher", (Object)new PlayfairCipher("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"));
        RAND_ENCRYPTERS.register((Object)new PolluxCipher());
        RAND_ENCRYPTERS.register((Object)new PortaxCipher());
        RAND_ENCRYPTERS.registerAll((Object[])new ICipher[]{new QuagmireICipher(), new QuagmireIICipher(), new QuagmireIIICipher(), new QuagmireIVCipher()});
        RAND_ENCRYPTERS.registerAll((Object[])new ICipher[]{new RailFenceCipher(), new RedefenceCipher()});
        RAND_ENCRYPTERS.register((Object)new RouteTranspositionCipher());
        RAND_ENCRYPTERS.register((Object)new RunningKeyCipher());
        RAND_ENCRYPTERS.register((Object)new SeriatedPlayfairCipher());
        RAND_ENCRYPTERS.register((Object)new SolitaireCipher());
        RAND_ENCRYPTERS.register((Object)new SwagmanCipher());
        RAND_ENCRYPTERS.register((Object)new TrifidCipher());
        RAND_ENCRYPTERS.register((Object)new TwoSquareCipher());
        RAND_ENCRYPTERS.register((Object)new TriSquareCipher());
        RAND_ENCRYPTERS.register((Object)new EnigmaPlugboardCipher(EnigmaLib.ENIGMA_M3));
        RAND_ENCRYPTERS.register((Object)"enigmaicipher", (Object)new EnigmaPlugboardCipher(EnigmaLib.ENIGMA_I));
        RAND_ENCRYPTERS.register((Object)"enigmadcipher", (Object)new EnigmaPlugboardCipher(EnigmaLib.ENIGMA_D));
        RAND_ENCRYPTERS.register((Object)new HillCipher());
        RAND_ENCRYPTERS.register((Object)new HillExtendedCipher());
        RAND_ENCRYPTERS.register((Object)new HillSubstitutionCipher());
        RAND_ENCRYPTERS.register((Object)new RagbabyCipher());
        RAND_ENCRYPTERS.register((Object)new GrilleCipher());
        RAND_ENCRYPTERS.register((Object)new HuttonCipher());
        RAND_ENCRYPTERS.freeze();
    }

    static {
        EncrypterRegistry.registerAll();
        System.out.println(RAND_ENCRYPTERS.size());
    }
}

