/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers;

import javax.annotation.Nullable;
import tools.cipher.base.ciphers.BiKey;
import tools.cipher.base.ciphers.BiKeyCipher;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.types.FullStringKeyType;
import tools.cipher.base.key.types.VariableStringKeyType;

public class NihilistSubstitutionCipher
extends BiKeyCipher<String, String, FullStringKeyType.Builder, VariableStringKeyType.Builder> {
    public NihilistSubstitutionCipher() {
        super((IKeyType.IKeyBuilder)FullStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIKLMNOPQRSTUVWXYZ"), (IKeyType.IKeyBuilder)VariableStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIKLMNOPQRSTUVWXYZ").setRange(2, Integer.MAX_VALUE));
    }

    public VariableStringKeyType.Builder limitDomainForSecondKey(VariableStringKeyType.Builder secondKey) {
        return secondKey.setRange(2, 15);
    }

    public CharSequence normaliseText(CharSequence plainText, BiKey<String, String> key) {
        StringBuilder builder = new StringBuilder(plainText.length());
        for (int i = 0; i < plainText.length(); ++i) {
            char c = plainText.charAt(i);
            builder.append(c == 'J' ? (char)'I' : (char)c);
        }
        return builder;
    }

    public CharSequence encode(CharSequence plainText, BiKey<String, String> key) {
        String cipherText = "";
        for (int i = 0; i < plainText.length(); ++i) {
            String strNo;
            int no = NihilistSubstitutionCipher.getNumberValue(plainText.charAt(i), (String)key.getFirstKey()) + NihilistSubstitutionCipher.getNumberValue(((String)key.getSecondKey()).charAt(i % ((String)key.getSecondKey()).length()), (String)key.getFirstKey());
            if (no >= 100) {
                no -= 100;
            }
            if ((strNo = "" + no).length() < 2) {
                strNo = "0" + strNo;
            }
            cipherText = cipherText + strNo;
        }
        return cipherText;
    }

    public char[] decodeEfficiently(CharSequence cipherText, BiKey<String, String> key) {
        return this.decodeEfficiently(cipherText, new char[cipherText.length() / 2], key);
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, BiKey<String, String> key) {
        for (int i = 0; i < cipherText.length() / 2; ++i) {
            int no = (cipherText.charAt(i * 2) - 48) * 10 + (cipherText.charAt(i * 2 + 1) - 48);
            if (no <= 10) {
                no += 100;
            }
            int column = (no -= NihilistSubstitutionCipher.getNumberValue(((String)key.getSecondKey()).charAt(i % ((String)key.getSecondKey()).length()), (String)key.getFirstKey())) % 10;
            int row = (no - column) / 10 - 1;
            plainText[i] = ((String)key.getFirstKey()).charAt(row * 5 + column - 1);
        }
        return plainText;
    }

    private static int getNumberValue(char character, String keysquare) {
        int index = keysquare.indexOf(character);
        int row = index / 5 + 1;
        int column = index % 5 + 1;
        return row * 10 + column;
    }
}

