/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers;

import javax.annotation.Nullable;
import tools.cipher.base.ciphers.UniKeyCipher;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.types.VariableStringKeyType;

public class CadenusCipher
extends UniKeyCipher<String, VariableStringKeyType.Builder> {
    public CadenusCipher() {
        super((IKeyType.IKeyBuilder)VariableStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ").setRange(2, Integer.MAX_VALUE));
    }

    public VariableStringKeyType.Builder limitDomainForFirstKey(VariableStringKeyType.Builder firstKey) {
        return firstKey.setRange(2, 5);
    }

    public CharSequence normaliseText(CharSequence plainText, String key) {
        int blockSize = 25 * key.length();
        if (plainText.length() % blockSize != 0) {
            StringBuilder builder = new StringBuilder(plainText.length() + blockSize - plainText.length() % blockSize);
            builder.append(plainText);
            while (builder.length() % blockSize != 0) {
                builder.append('X');
            }
            return builder;
        }
        return plainText;
    }

    public CharSequence encode(CharSequence plainText, String key) {
        if (plainText.length() > key.length() * 25) {
            String combinedMulti = "";
            for (int i = 0; i < plainText.length() / (key.length() * 25); ++i) {
                combinedMulti = combinedMulti + this.encode(plainText.subSequence(i * key.length() * 25, (i + 1) * key.length() * 25), key);
            }
            return combinedMulti;
        }
        int keyLength = key.length();
        int[] order = new int[key.length()];
        int p = 0;
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + 1)) {
            for (int i = 0; i < order.length; ++i) {
                if (ch != key.charAt(i)) continue;
                order[i] = p++;
            }
        }
        char[] temp_grid = new char[plainText.length()];
        for (int j = 0; j < 25; ++j) {
            for (int i = 0; i < keyLength; ++i) {
                int newColumn = order[i];
                int newIndex = (j - CadenusCipher.charValue(key.charAt(i)) + 25) % 25;
                temp_grid[newIndex * keyLength + newColumn] = plainText.charAt(j * keyLength + i);
            }
        }
        return new String(temp_grid);
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, String key) {
        int[] order = new int[key.length()];
        int p = 0;
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + 1)) {
            for (int i = 0; i < order.length; ++i) {
                if (ch != key.charAt(i)) continue;
                order[p++] = i;
            }
        }
        return CadenusCipher.decode(cipherText, plainText, key, order);
    }

    public static char[] decode(CharSequence cipherText, @Nullable char[] plainText, String key, int[] order) {
        int keyLength = order.length;
        int gridSize = keyLength * 25;
        if (cipherText.length() % gridSize != 0) {
            throw new IllegalArgumentException("Ciphertext must be a multiple of " + gridSize);
        }
        if (cipherText.length() > gridSize) {
            for (int i = 0; i < cipherText.length(); i += gridSize) {
                char[] decodedPart = CadenusCipher.decode(cipherText.subSequence(i, i + gridSize), new char[gridSize], key, order);
                System.arraycopy(decodedPart, 0, plainText, i, gridSize);
            }
            return plainText;
        }
        for (int j = 0; j < 25; ++j) {
            for (int i = 0; i < keyLength; ++i) {
                int newColumn = order[i];
                int newIndex = (j + CadenusCipher.charValue(key.charAt(newColumn))) % 25;
                plainText[newIndex * keyLength + newColumn] = cipherText.charAt(j * keyLength + i);
            }
        }
        return plainText;
    }

    public static int charValue(char character) {
        if (character >= 'W') {
            return (90 - character + 1) % 25;
        }
        return (90 - character) % 25;
    }
}

