/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers;

import javax.annotation.Nullable;
import tools.cipher.base.ciphers.BiKey;
import tools.cipher.base.ciphers.TriKey;
import tools.cipher.base.ciphers.TriKeyCipher;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.types.EnumKeyType;
import tools.cipher.base.key.types.OrderedIntegerKeyType;
import tools.cipher.base.key.types.SquareStringKeyType;
import tools.cipher.ciphers.ColumnarTranspositionCipher;
import tools.cipher.util.ReadMode;

public class ADFGXCipher
extends TriKeyCipher<String, Integer[], ReadMode, SquareStringKeyType.Builder, OrderedIntegerKeyType.Builder, EnumKeyType.Builder<ReadMode>> {
    private static final ColumnarTranspositionCipher transpostion = new ColumnarTranspositionCipher();
    private final String colLabels;

    public ADFGXCipher(String alphabet, String colLabelsIn) {
        super((IKeyType.IKeyBuilder)SquareStringKeyType.builder().setAlphabet((CharSequence)alphabet).setDim(colLabelsIn.length(), colLabelsIn.length()), (IKeyType.IKeyBuilder)OrderedIntegerKeyType.builder().setMin(1).setMax(Integer.MAX_VALUE), (IKeyType.IKeyBuilder)EnumKeyType.builder(ReadMode.class).setUniverse((Enum[])new ReadMode[]{ReadMode.DOWN}));
        this.colLabels = colLabelsIn;
    }

    public ADFGXCipher() {
        this("ABCDEFGHIKLMNOPQRSTUVWXYZ", "ADFGX");
    }

    public IKeyType.IKeyBuilder<Integer[]> limitDomainForSecondKey(OrderedIntegerKeyType.Builder secondKey) {
        return secondKey.setRange(2, 9);
    }

    public CharSequence normaliseText(CharSequence plainText, TriKey<String, Integer[], ReadMode> key) {
        StringBuilder builder = new StringBuilder(plainText.length());
        for (int i = 0; i < plainText.length(); ++i) {
            char c = plainText.charAt(i);
            builder.append(c == 'J' ? (char)'I' : (char)c);
        }
        return builder;
    }

    public boolean isValid(TriKey<String, Integer[], ReadMode> key) {
        return Math.sqrt(((String)key.getFirstKey()).length()) == (double)this.colLabels.length() && super.isValid(key);
    }

    public CharSequence encode(CharSequence plainText, TriKey<String, Integer[], ReadMode> key) {
        int size = this.colLabels.length();
        StringBuilder cipherText = new StringBuilder(plainText.length() * 2);
        for (int i = 0; i < plainText.length(); ++i) {
            char c = plainText.charAt(i);
            int charIndex = ((String)key.getFirstKey()).indexOf(c);
            int row = (int)Math.floor((double)charIndex / (double)size);
            int column = charIndex % size;
            cipherText.append(this.colLabels.charAt(row));
            cipherText.append(this.colLabels.charAt(column));
        }
        return transpostion.encode((CharSequence)cipherText, (BiKey<Integer[], ReadMode>)BiKey.of((Object)key.getSecondKey(), (Object)key.getThirdKey()));
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, TriKey<String, Integer[], ReadMode> key) {
        return ADFGXCipher.decodeTransformed(transpostion.decodeEfficiently(cipherText, plainText, (BiKey<Integer[], ReadMode>)BiKey.of((Object)key.getSecondKey(), (Object)key.getThirdKey())), (String)key.getFirstKey(), this.colLabels);
    }

    private static char[] decodeTransformed(char[] untransformedText, String keysquare, String adfgvx) {
        char[] plainText = new char[untransformedText.length / 2];
        for (int i = 0; i < untransformedText.length; i += 2) {
            char c1 = untransformedText[i];
            char c2 = untransformedText[i + 1];
            int row = adfgvx.indexOf(c1);
            int column = adfgvx.indexOf(c2);
            if (row == -1 || column == -1) continue;
            plainText[i / 2] = keysquare.charAt(row * adfgvx.length() + column);
        }
        return plainText;
    }
}

