/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers;

import javax.annotation.Nullable;
import tools.cipher.base.ciphers.TriKey;
import tools.cipher.base.ciphers.TriKeyCipher;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.types.FullStringKeyType;
import tools.cipher.base.key.types.ObjectKeyType;
import tools.cipher.base.key.types.VariableStringKeyType;
import tools.cipher.lib.characters.CharSequenceUtils;
import tools.cipher.util.Quagmire;

public class QuagmireIICipher
extends TriKeyCipher<String, String, Character, FullStringKeyType.Builder, VariableStringKeyType.Builder, ObjectKeyType.Builder<Character>> {
    public QuagmireIICipher() {
        super((IKeyType.IKeyBuilder)FullStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ"), (IKeyType.IKeyBuilder)VariableStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ").setRange(2, Integer.MAX_VALUE), (IKeyType.IKeyBuilder)ObjectKeyType.builder().setUniverse((Object[])CharSequenceUtils.toArray((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ")));
    }

    public VariableStringKeyType.Builder limitDomainForSecondKey(VariableStringKeyType.Builder secondKey) {
        return secondKey.setRange(2, 15);
    }

    public CharSequence encode(CharSequence plainText, TriKey<String, String, Character> key) {
        return Quagmire.encode(plainText, "ABCDEFGHIJKLMNOPQRSTUVWXYZ", (String)key.getFirstKey(), (String)key.getSecondKey(), ((Character)key.getThirdKey()).charValue());
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, TriKey<String, String, Character> key) {
        return Quagmire.decode(cipherText, plainText, "ABCDEFGHIJKLMNOPQRSTUVWXYZ", (String)key.getFirstKey(), (String)key.getSecondKey(), ((Character)key.getThirdKey()).charValue());
    }
}

