/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.ciphers;

import com.alexbarter.lib.util.ArrayUtil;
import javax.annotation.Nullable;
import tools.cipher.base.ciphers.QuadKey;
import tools.cipher.base.ciphers.QuadKeyCipher;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.types.IntegerKeyType;
import tools.cipher.base.key.types.OrderedIntegerKeyType;
import tools.cipher.ciphers.enigma.EnigmaMachine;
import tools.cipher.lib.CipherUtils;
import tools.cipher.lib.characters.CharArrayWrapper;

public class EnigmaCipher
extends QuadKeyCipher<Integer[], Integer[], Integer[], Integer, OrderedIntegerKeyType.Builder, OrderedIntegerKeyType.Builder, OrderedIntegerKeyType.Builder, IntegerKeyType.Builder> {
    private EnigmaMachine machine;

    public EnigmaCipher(EnigmaMachine machine) {
        super((IKeyType.IKeyBuilder)OrderedIntegerKeyType.builder().setSize(3).setEntryRange(26).setRepeats().setDisplay(CipherUtils::displayAsLetters), (IKeyType.IKeyBuilder)OrderedIntegerKeyType.builder().setSize(3).setEntryRange(26).setRepeats().setDisplay(CipherUtils::displayAsLetters), (IKeyType.IKeyBuilder)OrderedIntegerKeyType.builder().setSize(3).setEntryRange(machine.getRotorCount()), (IKeyType.IKeyBuilder)IntegerKeyType.builder().setRange(0, machine.getReflectorCount() - 1));
        this.machine = machine;
    }

    @Deprecated
    public EnigmaCipher setMachine(EnigmaMachine machine) {
        this.machine = machine;
        return this;
    }

    public CharSequence encode(CharSequence plainText, QuadKey<Integer[], Integer[], Integer[], Integer> key) {
        return new CharArrayWrapper(this.decodeEfficiently(plainText, key));
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, QuadKey<Integer[], Integer[], Integer[], Integer> key) {
        Integer[] indicator = (Integer[])ArrayUtil.copy((Object[])((Object[])key.getFirstKey()));
        Integer[] ring = (Integer[])ArrayUtil.copy((Object[])((Object[])key.getSecondKey()));
        int thinRotor = 0;
        for (int i = 0; i < cipherText.length(); ++i) {
            int r;
            this.nextRotorPosition((Integer[])key.getThirdKey(), indicator);
            int ch = cipherText.charAt(i) - 65;
            if (this.machine.hasETW()) {
                ch = this.nextCharacter(ch, this.machine.getETWInverse());
            }
            for (r = 2; r >= 0; --r) {
                ch = this.nextCharacter(ch, this.machine.rotors[((Integer[])key.getThirdKey())[r]], indicator[r] - ring[r]);
            }
            if (this.machine.hasThinRotor()) {
                ch = this.nextCharacter(ch, this.machine.thinRotor[thinRotor]);
            }
            ch = this.nextCharacter(ch, this.machine.reflector[(Integer)key.getFourthKey()]);
            if (this.machine.hasThinRotor()) {
                ch = this.nextCharacter(ch, this.machine.thinRotorInverse[thinRotor]);
            }
            for (r = 0; r < 3; ++r) {
                ch = this.nextCharacter(ch, this.machine.rotorsInverse[((Integer[])key.getThirdKey())[r]], indicator[r] - ring[r]);
            }
            if (this.machine.hasETW()) {
                ch = this.nextCharacter(ch, this.machine.getETW());
            }
            plainText[i] = (char)(ch + 65);
        }
        return plainText;
    }

    public void nextRotorPosition(Integer[] rotors, Integer[] indicator) {
        if (this.machine.getStepping()) {
            Integer[] integerArray;
            Object[] middleNotches = this.machine.notches[rotors[1]];
            Object[] endNotches = this.machine.notches[rotors[2]];
            if (ArrayUtil.contains((Object[])middleNotches, (Object)indicator[1])) {
                integerArray = indicator;
                Integer.valueOf(integerArray[0] + 1);
                integerArray = indicator;
                Integer.valueOf(integerArray[1] + 1);
                if (indicator[0] > 25) {
                    indicator[0] = 0;
                }
                if (indicator[1] > 25) {
                    indicator[1] = 0;
                }
            }
            if (ArrayUtil.contains((Object[])endNotches, (Object)indicator[2])) {
                integerArray = indicator;
                Integer.valueOf(integerArray[1] + 1);
                if (indicator[1] > 25) {
                    indicator[1] = 0;
                }
            }
            integerArray = indicator;
            Integer.valueOf(integerArray[2] + 1);
            if (indicator[2] > 25) {
                indicator[2] = 0;
            }
        } else {
            Object[] endNotches = this.machine.notches[rotors[2]];
            if (ArrayUtil.contains((Object[])endNotches, (Object)indicator[2])) {
                Object[] middleNotches = this.machine.notches[rotors[1]];
                if (ArrayUtil.contains((Object[])middleNotches, (Object)indicator[1])) {
                    indicator[0] = (indicator[0] + 1) % 26;
                }
                indicator[1] = (indicator[1] + 1) % 26;
            }
            indicator[2] = (indicator[2] + 1) % 26;
        }
    }

    public int nextCharacter(int ch, Integer[] key) {
        return key[ch];
    }

    public int nextCharacter(int ch, Integer[] key, int offset) {
        if (offset > 0) {
            if ((ch += offset) > 25) {
                ch -= 26;
            }
            ch = this.nextCharacter(ch, key);
            if ((ch -= offset) < 0) {
                ch += 26;
            }
        } else if (offset < 0) {
            if ((ch += offset) < 0) {
                ch += 26;
            }
            ch = this.nextCharacter(ch, key);
            if ((ch -= offset) > 25) {
                ch -= 26;
            }
        } else {
            ch = this.nextCharacter(ch, key);
        }
        return ch;
    }
}

