/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.solve;

import com.alexbarter.ciphertool.base.ciphers.UniKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.ICipherProgram;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.base.key.IRangedKeyType;
import com.alexbarter.ciphertool.base.solve.CipherAttack;
import com.alexbarter.ciphertool.base.solve.DecryptionMethod;
import com.alexbarter.ciphertool.base.solve.IKeySearchAttack;

public class HomophonicAttack<C extends UniKeyCipher<String, ? extends IRangedKeyType.IRangedKeyBuilder<String>>>
extends CipherAttack<String, C>
implements IKeySearchAttack<String> {
    public int[] periodRange;
    private int charStep = 1;

    public HomophonicAttack(C cipher, String displayName) {
        super(cipher, displayName);
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.PERIODIC_KEY, DecryptionMethod.BRUTE_FORCE});
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        switch (method) {
            case PERIODIC_KEY: {
                return this.tryKeySearch(this.createTracker(text, app), 4);
            }
        }
        return super.attemptAttack(text, method, app);
    }

    public String useStringGetKey(IDecryptionTracker tracker, String periodicPart) {
        return periodicPart;
    }

    public int getCharStep() {
        return this.charStep;
    }

    public HomophonicAttack<C> setCharStep(int charStep) {
        this.charStep = charStep;
        return this;
    }

    public IDecryptionTracker createTracker(CharSequence text, ICipherProgram app) {
        return super.createTracker(text, app).setOutputLength(length -> length / 2);
    }
}

