/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers.registry;

import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.ciphers.ADFGXCipher;
import com.alexbarter.ciphertool.ciphers.AMSCOCipher;
import com.alexbarter.ciphertool.ciphers.AffineCipher;
import com.alexbarter.ciphertool.ciphers.AutokeyCipher;
import com.alexbarter.ciphertool.ciphers.BazeriesCipher;
import com.alexbarter.ciphertool.ciphers.BifidCipher;
import com.alexbarter.ciphertool.ciphers.CadenusCipher;
import com.alexbarter.ciphertool.ciphers.CaesarCipher;
import com.alexbarter.ciphertool.ciphers.ColumnarTranspositionCipher;
import com.alexbarter.ciphertool.ciphers.ConjugatedBifidCipher;
import com.alexbarter.ciphertool.ciphers.DigrafidCipher;
import com.alexbarter.ciphertool.ciphers.DoubleColumnarTranspositionCipher;
import com.alexbarter.ciphertool.ciphers.EnigmaPlugboardCipher;
import com.alexbarter.ciphertool.ciphers.FourSquareCipher;
import com.alexbarter.ciphertool.ciphers.FractionatedMorseCipher;
import com.alexbarter.ciphertool.ciphers.GrilleCipher;
import com.alexbarter.ciphertool.ciphers.HillCipher;
import com.alexbarter.ciphertool.ciphers.HillExtendedCipher;
import com.alexbarter.ciphertool.ciphers.HillSubstitutionCipher;
import com.alexbarter.ciphertool.ciphers.HomophonicCipher;
import com.alexbarter.ciphertool.ciphers.HuttonCipher;
import com.alexbarter.ciphertool.ciphers.KeywordCipher;
import com.alexbarter.ciphertool.ciphers.MorbitCipher;
import com.alexbarter.ciphertool.ciphers.MyszkowskiCipher;
import com.alexbarter.ciphertool.ciphers.NicodemusCipher;
import com.alexbarter.ciphertool.ciphers.NihilistSubstitutionCipher;
import com.alexbarter.ciphertool.ciphers.NihilistTranspositionCipher;
import com.alexbarter.ciphertool.ciphers.PeriodicGromarkCipher;
import com.alexbarter.ciphertool.ciphers.PhillipsCipher;
import com.alexbarter.ciphertool.ciphers.PlayfairCipher;
import com.alexbarter.ciphertool.ciphers.PolluxCipher;
import com.alexbarter.ciphertool.ciphers.PortaxCipher;
import com.alexbarter.ciphertool.ciphers.ProgressiveCipher;
import com.alexbarter.ciphertool.ciphers.QuagmireICipher;
import com.alexbarter.ciphertool.ciphers.QuagmireIICipher;
import com.alexbarter.ciphertool.ciphers.QuagmireIIICipher;
import com.alexbarter.ciphertool.ciphers.QuagmireIVCipher;
import com.alexbarter.ciphertool.ciphers.RagbabyCipher;
import com.alexbarter.ciphertool.ciphers.RailFenceCipher;
import com.alexbarter.ciphertool.ciphers.RedefenceCipher;
import com.alexbarter.ciphertool.ciphers.RouteTranspositionCipher;
import com.alexbarter.ciphertool.ciphers.RunningKeyCipher;
import com.alexbarter.ciphertool.ciphers.SeriatedPlayfairCipher;
import com.alexbarter.ciphertool.ciphers.SlidefairCipher;
import com.alexbarter.ciphertool.ciphers.SolitaireCipher;
import com.alexbarter.ciphertool.ciphers.SwagmanCipher;
import com.alexbarter.ciphertool.ciphers.TriSquareCipher;
import com.alexbarter.ciphertool.ciphers.TrifidCipher;
import com.alexbarter.ciphertool.ciphers.TwoSquareCipher;
import com.alexbarter.ciphertool.ciphers.VigenereCipher;
import com.alexbarter.ciphertool.ciphers.enigma.EnigmaLib;
import com.alexbarter.ciphertool.lib.registry.IRegistry;
import com.alexbarter.ciphertool.lib.registry.Registry;
import com.alexbarter.ciphertool.util.VigenereType;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;

public class EncrypterRegistry {
    public static IRegistry<String, ICipher> RAND_ENCRYPTERS = Registry.builder(ICipher.class).setNamingScheme(cipher -> cipher.getClass().getSimpleName().toLowerCase(Locale.UK).replace("cipher", "")).build();
    private static Random RAND = new Random();

    public static ICipher<?> getFromName(String key) {
        return (ICipher)RAND_ENCRYPTERS.get((Object)key);
    }

    public static int getDifficulty(String name) {
        return RAND_ENCRYPTERS.apply((Object)name, ICipher::getDifficulty).orElse(ICipher.Difficulty.EASY).getLevel();
    }

    @Nullable
    public static ICipher<?> getEncrypterWith(int maxDifficulty) {
        return RAND_ENCRYPTERS.getValues().stream().filter(v -> v.getDifficulty().isEasierThan(maxDifficulty)).sorted((o1, o2) -> RAND.nextBoolean() ? 1 : -1).findAny().orElse(null);
    }

    public static void registerAll() {
        if (RAND_ENCRYPTERS.frozen()) {
            return;
        }
        RAND_ENCRYPTERS.register((Object)new ADFGXCipher());
        RAND_ENCRYPTERS.register((Object)"adfgvx", (Object)new ADFGXCipher("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789", "ADFGVX"));
        RAND_ENCRYPTERS.registerAll((Object[])new ICipher[]{new AffineCipher(), new AMSCOCipher()});
        RAND_ENCRYPTERS.register((Object)new BazeriesCipher());
        RAND_ENCRYPTERS.register((Object)new BifidCipher());
        RAND_ENCRYPTERS.register((Object)new CaesarCipher());
        RAND_ENCRYPTERS.register((Object)new CadenusCipher());
        RAND_ENCRYPTERS.register((Object)new ColumnarTranspositionCipher());
        RAND_ENCRYPTERS.register((Object)new DoubleColumnarTranspositionCipher());
        RAND_ENCRYPTERS.register((Object)new ConjugatedBifidCipher());
        RAND_ENCRYPTERS.register((Object)new DigrafidCipher());
        RAND_ENCRYPTERS.register((Object)new FourSquareCipher());
        RAND_ENCRYPTERS.register((Object)new FractionatedMorseCipher());
        RAND_ENCRYPTERS.register((Object)new HomophonicCipher());
        RAND_ENCRYPTERS.register((Object)new KeywordCipher());
        RAND_ENCRYPTERS.register((Object)new MorbitCipher());
        RAND_ENCRYPTERS.register((Object)new MyszkowskiCipher());
        for (VigenereType type : VigenereType.NORMAL_LIST) {
            String name = type.getClass().getSimpleName().toLowerCase();
            RAND_ENCRYPTERS.register((Object)(name + "_auto_key"), (Object)new AutokeyCipher(type));
            RAND_ENCRYPTERS.register((Object)(name + "_nicodemus"), (Object)new NicodemusCipher(type));
            RAND_ENCRYPTERS.register((Object)(name + "_progressive_key"), (Object)new ProgressiveCipher(type));
            RAND_ENCRYPTERS.register((Object)name, (Object)new VigenereCipher(type));
        }
        for (VigenereType type : VigenereType.SLIDEFAIR_LIST) {
            RAND_ENCRYPTERS.register((Object)(type.getClass().getSimpleName().toLowerCase() + "_slidefair"), (Object)new SlidefairCipher(type));
        }
        RAND_ENCRYPTERS.register((Object)new NihilistSubstitutionCipher());
        RAND_ENCRYPTERS.register((Object)new NihilistTranspositionCipher());
        RAND_ENCRYPTERS.register((Object)new PeriodicGromarkCipher());
        RAND_ENCRYPTERS.register((Object)new PhillipsCipher());
        RAND_ENCRYPTERS.register((Object)new PlayfairCipher());
        RAND_ENCRYPTERS.register((Object)"playfair6x6cipher", (Object)new PlayfairCipher("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"));
        RAND_ENCRYPTERS.register((Object)new PolluxCipher());
        RAND_ENCRYPTERS.register((Object)new PortaxCipher());
        RAND_ENCRYPTERS.registerAll((Object[])new ICipher[]{new QuagmireICipher(), new QuagmireIICipher(), new QuagmireIIICipher(), new QuagmireIVCipher()});
        RAND_ENCRYPTERS.registerAll((Object[])new ICipher[]{new RailFenceCipher(), new RedefenceCipher()});
        RAND_ENCRYPTERS.register((Object)new RouteTranspositionCipher());
        RAND_ENCRYPTERS.register((Object)new RunningKeyCipher());
        RAND_ENCRYPTERS.register((Object)new SeriatedPlayfairCipher());
        RAND_ENCRYPTERS.register((Object)new SolitaireCipher());
        RAND_ENCRYPTERS.register((Object)new SwagmanCipher());
        RAND_ENCRYPTERS.register((Object)new TrifidCipher());
        RAND_ENCRYPTERS.register((Object)new TwoSquareCipher());
        RAND_ENCRYPTERS.register((Object)new TriSquareCipher());
        RAND_ENCRYPTERS.register((Object)new EnigmaPlugboardCipher(EnigmaLib.ENIGMA_M3));
        RAND_ENCRYPTERS.register((Object)"enigmaicipher", (Object)new EnigmaPlugboardCipher(EnigmaLib.ENIGMA_I));
        RAND_ENCRYPTERS.register((Object)"enigmadcipher", (Object)new EnigmaPlugboardCipher(EnigmaLib.ENIGMA_D));
        RAND_ENCRYPTERS.register((Object)new HillCipher());
        RAND_ENCRYPTERS.register((Object)new HillExtendedCipher());
        RAND_ENCRYPTERS.register((Object)new HillSubstitutionCipher());
        RAND_ENCRYPTERS.register((Object)new RagbabyCipher());
        RAND_ENCRYPTERS.register((Object)new GrilleCipher());
        RAND_ENCRYPTERS.register((Object)new HuttonCipher());
        RAND_ENCRYPTERS.freeze();
    }

    static {
        EncrypterRegistry.registerAll();
        System.out.println(RAND_ENCRYPTERS.size());
    }
}

