/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers.enigma;

import com.alexbarter.lib.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public class EnigmaUtil {
    public static final String POSTER_TEXT = "THEBODYTHATWASHEDUPONTHERIVERBANKBELONGEDTOAYOUNGSCIENTISTCALLEDJAMELIAITBOREALLTHEHALLMARKSOFAPROFESSIONALHITWHICHWOULDHAVEMADESENSEIFSHEWORKEDINNUCLEARPHYSICSORBIOWARFAREBUTSHEDIDNTSHEWORKEDONGRAVITYWAVESANDFORTHELIFEOFMEICOULDNTSEEHOWTHATWOULDHAVEGOTHERKILLED";

    public static List<Integer> useCribInCipherText(String cipherText, String crib) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        block0: for (int i = 0; i < cipherText.length() - crib.length() + 1; ++i) {
            for (int j = 0; j < crib.length(); ++j) {
                if (cipherText.charAt(i + j) == crib.charAt(j)) continue block0;
            }
            positions.add(i);
        }
        return positions;
    }

    public static String displayPlugboard(Integer[] mapping) {
        StringJoiner joiner = new StringJoiner(" ", "[", "]");
        ArrayList<Integer> plugsUsed = new ArrayList<Integer>(mapping.length / 2);
        for (int i = 0; i < mapping.length; ++i) {
            int other;
            if (plugsUsed.contains(i) || (other = ArrayUtil.indexOf((Object[])mapping, (Object)i)) == i) continue;
            if (plugsUsed.contains(other)) {
                throw new IllegalArgumentException(String.format("Invalid plugboard mapping given involving indices %d, %d, %d", i, other, mapping[i]));
            }
            joiner.add(String.format("%c%c", Character.valueOf((char)(i + 65)), Character.valueOf((char)(other + 65))));
            plugsUsed.add(i);
            plugsUsed.add(other);
        }
        return joiner.toString();
    }
}

