/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.solve;

import com.alexbarter.ciphertool.base.ciphers.BiKey;
import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.base.settings.ICipherSettingProvider;
import com.alexbarter.ciphertool.base.settings.SettingTypes;
import com.alexbarter.ciphertool.base.solve.CipherAttack;
import com.alexbarter.ciphertool.base.solve.DecryptionMethod;
import com.alexbarter.ciphertool.ciphers.KeywordCipher;
import com.alexbarter.ciphertool.ciphers.NihilistSubstitutionCipher;
import com.alexbarter.ciphertool.lib.characters.CharArrayWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NihilistSubstitutionAttack
extends CipherAttack<BiKey<String, String>, NihilistSubstitutionCipher> {
    private int period = 5;

    public NihilistSubstitutionAttack() {
        super((ICipher)new NihilistSubstitutionCipher(), "Nihilist Substitution");
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING});
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createIntSpinner((String)"period", (int)5, (int)1, (int)100, (int)1, (value, cipher2) -> {
            this.period = value;
        })});
    }

    public IDecryptionTracker trySimulatedAnnealing(IDecryptionTracker tracker, int iterations) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < tracker.getLength() / 2; ++i) {
            list.add(Integer.valueOf(tracker.getCipherText().subSequence(i * 2, (i + 1) * 2).toString()));
        }
        char[] tempText = new char[tracker.getLength() / 2];
        boolean error = false;
        for (int i = 0; i < this.period; ++i) {
            List<Integer> old = NihilistSubstitutionAttack.getEveryNthChar(list, i, this.period);
            List<Integer> key = this.getBestKey(old, i);
            if (key.size() == 2) {
                this.output(tracker, "PeriodColumn %d -- %d%d", new Object[]{i, key.get(0), key.get(1)});
                int count = 0;
                for (int no : old) {
                    if (no <= 10) {
                        no += 100;
                    }
                    int newInt = no -= key.get(0) * 10 + key.get(1);
                    int alphaInt = (newInt / 10 - 1) * 5 + (newInt % 10 - 1);
                    tempText[count * this.period + i] = "ABCDEFGHIKLMNOPQRSTUVWXYZ".charAt(alphaInt);
                    ++count;
                }
                continue;
            }
            if (key.get(0) == key.get(1)) {
                this.output(tracker, "PeriodColumn %d -- Row: %d Column: %d-%d", new Object[]{i, key.get(0), key.get(2), key.get(3)});
            } else if (key.get(2) == key.get(3)) {
                this.output(tracker, "PeriodColumn %d -- Row: %d-%d Column: %d", new Object[]{i, key.get(0), key.get(1), key.get(2)});
            } else {
                this.output(tracker, "PeriodColumn %d -- Row: %d-%d Column: %d-%d", new Object[]{i, key.get(0), key.get(1), key.get(2), key.get(3)});
            }
            error = true;
        }
        if (!error) {
            CipherAttack substitutionHack = new CipherAttack((ICipher)new KeywordCipher("ABCDEFGHIKLMNOPQRSTUVWXYZ"), "Nihilist Sub").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}).setIterations(5).mute();
            IDecryptionTracker keywordTracker = substitutionHack.attemptAttack((CharSequence)new CharArrayWrapper(tempText), DecryptionMethod.SIMULATED_ANNEALING, tracker.getApp());
            this.updateIfBetterThanBest(tracker, keywordTracker.getBestSolution());
        } else {
            this.output(tracker, "Cannot complete decryption", new Object[0]);
        }
        return tracker;
    }

    public static List<Integer> getEveryNthChar(List<Integer> old, int start, int n) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < old.size(); ++i) {
            if (i % n != start) continue;
            list.add(old.get(i));
        }
        return list;
    }

    public List<Integer> getBestKey(List<Integer> nos, int periodColumn) {
        int rowMin = 1;
        int rowMax = 5;
        int colMin = 1;
        int colMax = 5;
        for (int no : nos) {
            int col;
            if (no <= 10) {
                no += 100;
            }
            if ((col = no % 10) == 0) {
                colMin = 5;
                colMax = 5;
                no -= 10;
            } else if (col - 1 <= 5) {
                colMin = Math.max(1, colMin);
                colMax = Math.min(col - 1, Math.max(colMin, colMax));
            } else {
                colMin = Math.max(col - 5, colMin);
                colMax = Math.min(5, Math.max(colMin, colMax));
            }
            int row = no / 10 % 10;
            if (row == 0) {
                rowMin = 5;
                rowMax = 5;
                continue;
            }
            if (row - 1 <= 5) {
                rowMin = Math.max(1, rowMin);
                rowMax = Math.min(row - 1, Math.max(rowMin, rowMax));
                continue;
            }
            rowMin = Math.max(row - 5, rowMin);
            rowMax = Math.min(5, Math.max(rowMin, rowMax));
        }
        if (rowMin == rowMax && colMin == colMax) {
            return Arrays.asList(rowMin, colMin);
        }
        return Arrays.asList(rowMin, rowMax, colMin, colMax);
    }
}

