/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.solve;

import com.alexbarter.ciphertool.base.ciphers.QuadKey;
import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.base.interfaces.ICipherProgram;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.base.key.KeyIterator;
import com.alexbarter.ciphertool.base.solve.CipherAttack;
import com.alexbarter.ciphertool.base.solve.DecryptionMethod;
import com.alexbarter.ciphertool.base.solve.DecryptionTracker;
import com.alexbarter.ciphertool.ciphers.EnigmaCipher;
import com.alexbarter.ciphertool.ciphers.enigma.EnigmaLib;
import com.alexbarter.ciphertool.ciphers.enigma.EnigmaMachine;
import com.alexbarter.ciphertool.lib.Timer;
import com.alexbarter.ciphertool.lib.fitness.TextFitness;
import com.alexbarter.ciphertool.lib.language.ILanguage;
import com.alexbarter.ciphertool.lib.result.DynamicResultList;
import com.alexbarter.ciphertool.lib.result.Result;
import com.alexbarter.ciphertool.lib.stats.StatIC;
import com.alexbarter.ciphertool.solve.EnigmaAttack;
import com.alexbarter.lib.util.MathUtil;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EnigmaUhrAttack
extends CipherAttack<QuadKey<Integer[], Integer[], Integer[], Integer>, EnigmaCipher> {
    private JComboBox<EnigmaMachine> machineSelection;
    private JComboBox<String> reflectorSelection;
    private JTextField plugboardDefinition;

    public EnigmaUhrAttack() {
        super((ICipher)new EnigmaCipher(EnigmaLib.ENIGMA_M3), "Enigma - Plugboard Uhr");
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE});
        this.machineSelection = new JComboBox();
        this.reflectorSelection = new JComboBox();
        this.plugboardDefinition = new JTextField();
        Stream.of(EnigmaLib.MACHINES).filter(m -> m.isSolvable() && m.canPlugboard() && !m.hasThinRotor() && m.canUhr()).forEach(this.machineSelection::addItem);
        this.machineSelection.addActionListener(event -> {
            EnigmaMachine currentMachine = (EnigmaMachine)this.machineSelection.getSelectedItem();
            this.reflectorSelection.removeAllItems();
            if (currentMachine.getReflectorCount() > 1) {
                this.reflectorSelection.addItem("-Check all-");
            }
            for (String reflectorName : currentMachine.reflectorNames) {
                this.reflectorSelection.addItem(reflectorName);
            }
        });
        EnigmaMachine currentMachine = (EnigmaMachine)this.machineSelection.getSelectedItem();
        if (currentMachine.getReflectorCount() > 1) {
            this.reflectorSelection.addItem("-Check all-");
        }
        for (String reflectorName : currentMachine.reflectorNames) {
            this.reflectorSelection.addItem(reflectorName);
        }
    }

    public void createSettingsUI(JDialog dialog, JPanel panel) {
        panel.add(this.machineSelection);
        panel.add(this.reflectorSelection);
        panel.add(this.plugboardDefinition);
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        EnigmaTask task = new EnigmaTask(text, app);
        task.machine = (EnigmaMachine)this.machineSelection.getSelectedItem();
        ((EnigmaCipher)this.getCipher()).setMachine(task.machine);
        task.reflectorTest = this.reflectorSelection.getSelectedIndex() - 1;
        task.start = 0;
        task.end = task.machine.getReflectorCount();
        if (task.reflectorTest != -1) {
            task.start = task.reflectorTest;
            task.end = task.start + 1;
        }
        String plugboardInput = this.plugboardDefinition.getText();
        char[][] plugboardDefinition = new char[10][3];
        boolean definitionProvided = false;
        int count = 0;
        for (String split : plugboardInput.split("[, ]")) {
            if (split.length() != 3) continue;
            plugboardDefinition[count++] = split.toCharArray();
            definitionProvided = true;
        }
        if (definitionProvided) {
            task.machine = task.machine.createWithUhr(4, plugboardDefinition);
        }
        this.output((IDecryptionTracker)task, "Using machine type: %s", new Object[]{task.machine});
        if (method == DecryptionMethod.BRUTE_FORCE) {
            long rotorCombos = MathUtil.factorial((int)task.machine.getRotorCount(), (int)3);
            this.output((IDecryptionTracker)task, "Going throught all combinations of the %d rotors (%d) and indicator settings (%d), totalling %d test subjects.", new Object[]{task.machine.getRotorCount(), rotorCombos, (int)Math.pow(26.0, 3.0), rotorCombos * (long)((int)Math.pow(26.0, 3.0))});
            double constant = 0.002;
            this.output((IDecryptionTracker)task, "Estimated time %c %ds, This may take a while...", new Object[]{Character.valueOf('\u2248'), (int)(constant * (double)rotorCombos * (double)task.getCipherText().length() * (double)(task.reflectorTest == -1 ? task.machine.getReflectorCount() : 1))});
            Timer timer = new Timer();
            KeyIterator.iterateIntegerArray(task::onList, (int)3, (int)task.machine.getRotorCount(), (boolean)false);
            this.output((IDecryptionTracker)task, "Time taken %fs", new Object[]{timer.getTimeRunning(TimeUnit.SECONDS)});
            task.squeezeFirst.sort();
            this.output((IDecryptionTracker)task, "Determining ring settings", new Object[0]);
            this.output((IDecryptionTracker)task, "%d possible indicators and rotor orders, therefore %d possible ring settings", new Object[]{task.squeezeFirst.size(), task.squeezeFirst.size() * 26 * 26});
            for (EnigmaAttack.EnigmaSection trial : task.squeezeFirst) {
                for (int s2 = 0; s2 < 26; ++s2) {
                    for (int s3 = 0; s3 < 26; ++s3) {
                        Integer[] indicator = trial.copyIndicator();
                        Integer[] ring = new Integer[]{0, s2, s3};
                        indicator[1] = (indicator[1] + s2) % 26;
                        indicator[2] = (indicator[2] + s3) % 26;
                        char[] plainText = ((EnigmaCipher)this.getCipher()).decodeEfficiently(task.getCipherText(), task.getHolder(), (QuadKey<Integer[], Integer[], Integer[], Integer>)QuadKey.of((Object)indicator, (Object)ring, (Object)trial.rotors, (Object)trial.reflector));
                        EnigmaAttack.EnigmaSection nextTrialSolution = new EnigmaAttack.EnigmaSection(StatIC.calculateMonoIC((char[])plainText) * 1000.0, trial.machine, indicator, trial.rotors, trial.reflector);
                        nextTrialSolution.ring = ring;
                        if (!task.squeezeSecond.add((Result)nextTrialSolution)) continue;
                        nextTrialSolution.bake();
                    }
                }
            }
            task.squeezeSecond.sort();
            app.out().println("Determining plugboard");
            for (EnigmaAttack.EnigmaSection trial : task.squeezeSecond) {
                this.output((IDecryptionTracker)task, "%s", new Object[]{trial});
            }
        }
        return task;
    }

    public class EnigmaTask
    extends DecryptionTracker {
        private EnigmaMachine machine;
        private int reflectorTest;
        private int start;
        private int end;
        private DynamicResultList<EnigmaAttack.EnigmaSection> squeezeFirst;
        private DynamicResultList<EnigmaAttack.EnigmaSection> squeezeSecond;

        public EnigmaTask(CharSequence text, ICipherProgram app) {
            super(text, app);
            this.squeezeFirst = new DynamicResultList(256);
            this.squeezeSecond = new DynamicResultList(64);
        }

        public boolean onList(Integer[] rotor) {
            return KeyIterator.iterateIntegerArray(o -> this.onList2(rotor, (Integer[])o), (int)3, (int)26, (boolean)true);
        }

        public boolean onList2(Integer[] rotor, Integer[] indicator) {
            for (int reflector = this.start; reflector < this.end; ++reflector) {
                char[] plainText = ((EnigmaCipher)EnigmaUhrAttack.this.getCipher()).decodeEfficiently(this.getCipherText(), this.getHolder(), (QuadKey<Integer[], Integer[], Integer[], Integer>)QuadKey.of((Object)indicator, (Object)EnigmaLib.DEFAULT_SETTING, (Object)rotor, (Object)reflector));
                EnigmaAttack.EnigmaSection trialSolution = new EnigmaAttack.EnigmaSection(TextFitness.scoreFitnessQuadgrams((char[])plainText, (ILanguage)this.getLanguage()), this.machine, indicator, rotor, reflector);
                if (this.squeezeFirst.add((Result)trialSolution)) {
                    trialSolution.bake();
                }
                this.getProgress().increment();
            }
            return true;
        }
    }
}

