/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.UniKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.FullStringKeyType;
import com.alexbarter.ciphertool.lib.characters.CharacterArrayWrapper;
import javax.annotation.Nullable;

public class RagbabyCipher
extends UniKeyCipher<String, FullStringKeyType.Builder> {
    public RagbabyCipher() {
        super((IKeyType.IKeyBuilder)FullStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIKLMNOPQRSTUVWYZ"));
    }

    public CharSequence normaliseText(CharSequence plainText, String key) {
        StringBuilder builder = new StringBuilder(plainText.length());
        for (int i = 0; i < plainText.length(); ++i) {
            char c = plainText.charAt(i);
            builder.append((char)(c == 'J' ? 73 : (c == 'X' ? 87 : (int)c)));
        }
        return builder;
    }

    public CharSequence encode(CharSequence plainText, String key) {
        Character[] cipherText = new Character[plainText.length()];
        int word = 2;
        int number = 1;
        for (int i = 0; i < plainText.length(); ++i) {
            char character = plainText.charAt(i);
            if (character == ' ') {
                cipherText[i] = Character.valueOf(' ');
                number = word++;
                continue;
            }
            cipherText[i] = Character.valueOf(key.charAt((key.indexOf(character) + number++) % key.length()));
        }
        return new CharacterArrayWrapper(cipherText);
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, String key) {
        int word;
        int number = word = 1;
        for (int i = 0; i < cipherText.length(); ++i) {
            char character = cipherText.charAt(i);
            if (character == ' ') {
                plainText[i] = 32;
                number = ++word;
                continue;
            }
            plainText[i] = key.charAt(((key.indexOf(character) - number++) % key.length() + key.length()) % key.length());
        }
        return plainText;
    }
}

