/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.UniKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.SquareMatrixKeyType;
import com.alexbarter.ciphertool.lib.characters.CharArrayWrapper;
import com.alexbarter.ciphertool.lib.matrix.Matrix;
import javax.annotation.Nullable;

public class HillCipher
extends UniKeyCipher<Matrix, SquareMatrixKeyType.Builder> {
    public HillCipher() {
        super((IKeyType.IKeyBuilder)SquareMatrixKeyType.builder());
    }

    public CharSequence normaliseText(CharSequence plainText, Matrix key) {
        int blockSize = key.size();
        if (plainText.length() % blockSize != 0) {
            StringBuilder builder = new StringBuilder(plainText.length() + blockSize - plainText.length() % blockSize);
            builder.append(plainText);
            while (builder.length() % blockSize != 0) {
                builder.append('X');
            }
            return builder;
        }
        return plainText;
    }

    public CharSequence encode(CharSequence plainText, Matrix key) {
        char[] cipherText = new char[plainText.length()];
        int size = key.size();
        for (int i = 0; i < plainText.length(); i += size) {
            Integer[] let = new Integer[size];
            for (int j = 0; j < size; ++j) {
                let[j] = plainText.charAt(i + j) - 65;
            }
            Matrix plainMatrix = new Matrix(let, size, 1);
            Matrix cipherMatrix = key.multiply(plainMatrix).modular(26);
            for (int j = 0; j < size; ++j) {
                cipherText[i + j] = (char)(cipherMatrix.data[j] + 65);
            }
        }
        return new CharArrayWrapper(cipherText);
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, Matrix key) {
        return this.decodeUsingInverse(cipherText, plainText, key.inverseMod(26));
    }

    public char[] decodeUsingInverse(CharSequence cipherText, char[] plainText, Matrix inverseMatrix) {
        int size = inverseMatrix.size();
        for (int i = 0; i < cipherText.length(); i += size) {
            Integer[] let = new Integer[size];
            for (int j = 0; j < size; ++j) {
                let[j] = cipherText.charAt(i + j) - 65;
            }
            Matrix cipherMatrix = new Matrix(let, size, 1);
            Matrix plainMatrix = inverseMatrix.multiply(cipherMatrix).modular(26);
            for (int j = 0; j < size; ++j) {
                plainText[i + j] = (char)(plainMatrix.data[j] + 65);
            }
        }
        return plainText;
    }
}

