/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.solve;

import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.base.interfaces.ICipherProgram;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.base.solve.CipherAttack;
import com.alexbarter.ciphertool.base.solve.DecryptionMethod;
import com.alexbarter.ciphertool.base.solve.DecryptionTracker;
import com.alexbarter.ciphertool.ciphers.KeywordCipher;
import com.alexbarter.ciphertool.ciphers.StraddleCheckerboardCipher;
import com.alexbarter.ciphertool.lib.characters.CharArrayWrapper;
import com.alexbarter.ciphertool.lib.characters.CharacterCount;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class StraddleCheckerboardAttack
extends CipherAttack<String, StraddleCheckerboardCipher> {
    public StraddleCheckerboardAttack() {
        super(null, "Straddle Checkerboard");
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.CALCULATED});
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        switch (method) {
            case CALCULATED: {
                DecryptionTracker tracker = new DecryptionTracker(text, app);
                List counts = CharacterCount.getOrderedCharacters((CharSequence)tracker.getCipherText());
                this.output((IDecryptionTracker)tracker, "Spare positions: %c %c", new Object[]{counts.get(0), counts.get(1)});
                char first = ((Character)counts.get(0)).charValue();
                char second = ((Character)counts.get(1)).charValue();
                ArrayList<CallSite> split = new ArrayList<CallSite>();
                for (int i = 0; i < tracker.getLength(); ++i) {
                    if (tracker.getCipherText().charAt(i) == first || tracker.getCipherText().charAt(i) == second) {
                        split.add((CallSite)((Object)("" + tracker.getCipherText().charAt(i) + tracker.getCipherText().charAt(i + 1))));
                        ++i;
                        continue;
                    }
                    split.add((CallSite)((Object)("" + tracker.getCipherText().charAt(i))));
                }
                app.out().println("" + split);
                char[] tempText = new char[split.size()];
                HashSet nonDupList = new HashSet(split);
                int t = 0;
                for (String nonDup : nonDupList) {
                    for (int i = 0; i < split.size(); ++i) {
                        if (!((String)split.get(i)).equals(nonDup)) continue;
                        tempText[i] = (char)(65 + t);
                    }
                    ++t;
                }
                CipherAttack substitutionHack = new CipherAttack((ICipher)new KeywordCipher("ABCDEFGHIJKLMNOPQRSTUVWXYZ"), "Straddle Checkerboard Sub").setAttackMethods(new DecryptionMethod[]{DecryptionMethod.SIMULATED_ANNEALING}).setIterations(10);
                IDecryptionTracker keywordTracker = substitutionHack.attemptAttack((CharSequence)new CharArrayWrapper(tempText), DecryptionMethod.SIMULATED_ANNEALING, app);
                this.updateIfBetterThanBest((IDecryptionTracker)tracker, keywordTracker.getBestSolution());
                keywordTracker.getProgress().reset();
                return tracker;
            }
        }
        return super.attemptAttack(text, method, app);
    }
}

