/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.solve;

import com.alexbarter.ciphertool.base.ciphers.QuadKey;
import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.base.interfaces.ICipherProgram;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.base.key.KeyIterator;
import com.alexbarter.ciphertool.base.solve.CipherAttack;
import com.alexbarter.ciphertool.base.solve.DecryptionMethod;
import com.alexbarter.ciphertool.base.solve.DecryptionTracker;
import com.alexbarter.ciphertool.ciphers.EnigmaCipher;
import com.alexbarter.ciphertool.ciphers.enigma.EnigmaLib;
import com.alexbarter.ciphertool.ciphers.enigma.EnigmaMachine;
import com.alexbarter.ciphertool.lib.CipherUtils;
import com.alexbarter.ciphertool.lib.Timer;
import com.alexbarter.ciphertool.lib.fitness.TextFitness;
import com.alexbarter.ciphertool.lib.language.ILanguage;
import com.alexbarter.ciphertool.lib.result.DynamicResultList;
import com.alexbarter.ciphertool.lib.result.Result;
import com.alexbarter.ciphertool.lib.result.ResultNegative;
import com.alexbarter.lib.util.ArrayUtil;
import com.alexbarter.lib.util.MathUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class EnigmaAttack
extends CipherAttack<QuadKey<Integer[], Integer[], Integer[], Integer>, EnigmaCipher> {
    private JComboBox<EnigmaMachine> machineSelection;
    private JComboBox<String> reflectorSelection;

    public EnigmaAttack() {
        super((ICipher)new EnigmaCipher(EnigmaLib.ENIGMA_M3), "Enigma - Plain");
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE});
        this.machineSelection = new JComboBox();
        this.reflectorSelection = new JComboBox();
        Stream.of(EnigmaLib.MACHINES).filter(m -> m.isSolvable() && !m.hasThinRotor()).forEach(m -> this.machineSelection.addItem((EnigmaMachine)m));
        this.machineSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EnigmaMachine currentMachine = (EnigmaMachine)EnigmaAttack.this.machineSelection.getSelectedItem();
                EnigmaAttack.this.reflectorSelection.removeAllItems();
                if (currentMachine.reflector.length > 1) {
                    EnigmaAttack.this.reflectorSelection.addItem("-Check all-");
                }
                for (String reflectorName : currentMachine.reflectorNames) {
                    EnigmaAttack.this.reflectorSelection.addItem(reflectorName);
                }
            }
        });
        EnigmaMachine currentMachine = (EnigmaMachine)this.machineSelection.getSelectedItem();
        if (currentMachine.reflector.length > 1) {
            this.reflectorSelection.addItem("-Check all-");
        }
        for (String reflectorName : currentMachine.reflectorNames) {
            this.reflectorSelection.addItem(reflectorName);
        }
    }

    public void createSettingsUI(JDialog dialog, JPanel panel) {
        panel.add(this.machineSelection);
        panel.add(this.reflectorSelection);
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        EnigmaTracker tracker = new EnigmaTracker(text, app);
        tracker.machine = (EnigmaMachine)this.machineSelection.getSelectedItem();
        ((EnigmaCipher)this.getCipher()).setMachine(tracker.machine);
        tracker.reflectorTest = this.reflectorSelection.getSelectedIndex() - 1;
        tracker.start = 0;
        tracker.end = tracker.machine.reflector.length;
        if (tracker.reflectorTest != -1) {
            tracker.start = tracker.reflectorTest;
            tracker.end = tracker.start + 1;
        }
        this.output((IDecryptionTracker)tracker, "Using machine type: %s", new Object[]{tracker.machine});
        if (method == DecryptionMethod.BRUTE_FORCE) {
            BigInteger numRotors = MathUtil.factorialLength((BigInteger)BigInteger.valueOf(tracker.machine.getRotorCount()), (BigInteger)BigInteger.valueOf(3L));
            tracker.getProgress().addMax(numRotors.multiply(BigInteger.valueOf(26L).pow(3)).multiply(BigInteger.valueOf(tracker.end - tracker.start)));
            Timer timer = new Timer();
            KeyIterator.iterateIntegerArray(tracker::iterateIndicator, (int)3, (int)tracker.machine.getRotorCount(), (boolean)false);
            this.output((IDecryptionTracker)tracker, "Time taken %fs", new Object[]{timer.getTimeRunning(TimeUnit.SECONDS)});
            tracker.squeezeFirst.sort();
            this.output((IDecryptionTracker)tracker, "Determining ring settings", new Object[0]);
            tracker.getProgress().addMax(BigInteger.valueOf(tracker.squeezeFirst.size()).multiply(BigInteger.valueOf(26L).multiply(BigInteger.valueOf(26L))));
            for (EnigmaSection trial : tracker.squeezeFirst) {
                for (int s2 = 0; s2 < 26; ++s2) {
                    for (int s3 = 0; s3 < 26; ++s3) {
                        Integer[] indicator = trial.copyIndicator();
                        Integer[] ring = new Integer[]{0, s2, s3};
                        indicator[1] = (indicator[1] + s2) % 26;
                        indicator[2] = (indicator[2] + s3) % 26;
                        this.decryptAndUpdate((IDecryptionTracker)tracker, QuadKey.of((Object)indicator, (Object)ring, (Object)trial.rotors, (Object)trial.reflector));
                    }
                }
            }
        }
        tracker.getProgress().finish();
        return tracker;
    }

    public static class EnigmaSection
    extends ResultNegative {
        public EnigmaMachine machine;
        public Integer[] indicator;
        public Integer[] ring;
        public Integer[] rotors;
        public int reflector;

        public EnigmaSection(double score, EnigmaMachine machine, Integer[] notchKey, Integer[] rotors, int reflector) {
            super(score);
            this.machine = machine;
            this.indicator = notchKey;
            this.rotors = rotors;
            this.reflector = reflector;
        }

        public void bake() {
            this.indicator = (Integer[])ArrayUtil.copy((Object[])this.indicator);
            this.rotors = (Integer[])ArrayUtil.copy((Object[])this.rotors);
            if (this.ring != null) {
                this.ring = (Integer[])ArrayUtil.copy((Object[])this.ring);
            }
        }

        public Integer[] copyIndicator() {
            return (Integer[])ArrayUtil.copy((Object[])this.indicator);
        }

        public String toKeyString() {
            return String.format("Machine Type: %s, Rotors:%s: Ind:%s, Ring:%s, Reflector:%d", this.machine, Arrays.toString((Object[])this.rotors), CipherUtils.displayAsLetters((Integer[])this.indicator), CipherUtils.displayAsLetters((Integer[])this.ring), this.reflector);
        }

        public String toString() {
            return String.format("%f, %s", this.score, this.toKeyString());
        }
    }

    public class EnigmaTracker
    extends DecryptionTracker {
        private EnigmaMachine machine;
        private int reflectorTest;
        private int start;
        private int end;
        private DynamicResultList<EnigmaSection> squeezeFirst;

        public EnigmaTracker(CharSequence text, ICipherProgram app) {
            super(text, app);
            this.squeezeFirst = new DynamicResultList(500);
        }

        public boolean iterateIndicator(Integer[] rotor) {
            return KeyIterator.iterateIntegerArray(indicator -> this.iterateReflector(rotor, (Integer[])indicator), (int)3, (int)26, (boolean)true);
        }

        public boolean iterateReflector(Integer[] rotor, Integer[] indicator) {
            for (int reflector = this.start; reflector < this.end; ++reflector) {
                char[] plainText = ((EnigmaCipher)EnigmaAttack.this.getCipher()).decodeEfficiently(this.getCipherText(), this.getHolder(), (QuadKey<Integer[], Integer[], Integer[], Integer>)QuadKey.of((Object)indicator, (Object)EnigmaLib.DEFAULT_SETTING, (Object)rotor, (Object)reflector));
                EnigmaSection trialSolution = new EnigmaSection(TextFitness.scoreFitnessQuadgrams((char[])plainText, (ILanguage)this.getLanguage()), this.machine, indicator, rotor, reflector);
                if (this.squeezeFirst.add((Result)trialSolution)) {
                    trialSolution.bake();
                }
                this.getProgress().increment();
            }
            return true;
        }
    }
}

