/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.solve;

import com.alexbarter.ciphertool.base.interfaces.ICipherProgram;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.base.solve.DecryptionMethod;
import com.alexbarter.ciphertool.base.solve.DecryptionTracker;
import com.alexbarter.ciphertool.base.solve.IDictionaryAttack;
import com.alexbarter.ciphertool.ciphers.AutokeyCipher;
import com.alexbarter.ciphertool.solve.PeriodicKeyAttack;

public class AutokeyAttack
extends PeriodicKeyAttack<AutokeyCipher>
implements IDictionaryAttack<String> {
    public AutokeyAttack(AutokeyCipher cipher, String displayName) {
        super(cipher, displayName);
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.PERIODIC_KEY, DecryptionMethod.DICTIONARY, DecryptionMethod.BRUTE_FORCE});
    }

    @Override
    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        switch (method) {
            case DICTIONARY: {
                DecryptionTracker tracker = new DecryptionTracker(text, app);
                return this.tryDictionaryAttack((IDecryptionTracker)tracker);
            }
        }
        return super.attemptAttack(text, method, app);
    }

    public String useWordToGetKey(DecryptionTracker tracker, String word) {
        return this.useStringGetKey((IDecryptionTracker)tracker, word);
    }
}

