/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.solve;

import com.alexbarter.ciphertool.base.ciphers.BiKey;
import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.base.interfaces.ICipherProgram;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.base.settings.ICipherSettingProvider;
import com.alexbarter.ciphertool.base.settings.SettingTypes;
import com.alexbarter.ciphertool.base.solve.CipherAttack;
import com.alexbarter.ciphertool.base.solve.DecryptionMethod;
import com.alexbarter.ciphertool.base.solve.DecryptionTracker;
import com.alexbarter.ciphertool.base.solve.IDictionaryAttack;
import com.alexbarter.ciphertool.base.solve.IKeySearchAttack;
import com.alexbarter.ciphertool.ciphers.NicodemusCipher;

public class NicodemusAttack
extends CipherAttack<BiKey<String, Integer>, NicodemusCipher>
implements IKeySearchAttack<BiKey<String, Integer>>,
IDictionaryAttack<BiKey<String, Integer>> {
    public int[] periodRange;

    public NicodemusAttack(NicodemusCipher cipher, String displayName) {
        super((ICipher)cipher, displayName);
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.DICTIONARY, DecryptionMethod.BRUTE_FORCE, DecryptionMethod.PERIODIC_KEY});
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createIntRange((String)"period_range", (int)2, (int)4, (int)2, (int)100, (int)1, (values, cipher2) -> {
            this.periodRange = values;
            cipher2.setFirstKeyDomain(builder -> builder.setRange(values));
        })});
        this.addSetting(new ICipherSettingProvider[]{SettingTypes.createIntSpinner((String)"block_size", (int)5, (int)1, (int)100, (int)1, (values, cipher2) -> cipher2.setSecondKeyDomain(builder -> builder.setSize(values.intValue())))});
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        IDecryptionTracker tracker = this.createTracker(text, app);
        switch (method) {
            case PERIODIC_KEY: {
                for (int period = this.periodRange[0]; period <= this.periodRange[1]; ++period) {
                    this.tryKeySearch(tracker, period);
                }
                return tracker;
            }
            case DICTIONARY: {
                return this.tryDictionaryAttack(tracker);
            }
        }
        return super.attemptAttack(text, method, app);
    }

    public BiKey<String, Integer> useStringGetKey(IDecryptionTracker tracker, String periodicPart) {
        return ((BiKey)((NicodemusCipher)this.getCipher()).randomiseKey(tracker.getLength())).setFirst((Object)periodicPart);
    }

    public BiKey<String, Integer> useWordToGetKey(DecryptionTracker tracker, String word) {
        return this.useStringGetKey((IDecryptionTracker)tracker, word);
    }
}

