/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.solve;

import com.alexbarter.ciphertool.base.ciphers.QuinKey;
import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.base.interfaces.ICipherProgram;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.base.key.KeyIterator;
import com.alexbarter.ciphertool.base.solve.CipherAttack;
import com.alexbarter.ciphertool.base.solve.DecryptionMethod;
import com.alexbarter.ciphertool.base.solve.DecryptionTracker;
import com.alexbarter.ciphertool.ciphers.EnigmaPlugboardCipher;
import com.alexbarter.ciphertool.ciphers.enigma.EnigmaLib;
import com.alexbarter.ciphertool.ciphers.enigma.EnigmaMachine;
import com.alexbarter.ciphertool.lib.Timer;
import com.alexbarter.ciphertool.lib.result.DynamicResultList;
import com.alexbarter.ciphertool.lib.result.Result;
import com.alexbarter.ciphertool.lib.result.Solution;
import com.alexbarter.ciphertool.lib.stats.StatIC;
import com.alexbarter.ciphertool.solve.EnigmaAttack;
import com.alexbarter.lib.util.ArrayUtil;
import com.alexbarter.lib.util.MathUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EnigmaPlugboardAttack
extends CipherAttack<QuinKey<Integer[], Integer[], Integer[], Integer, Integer[]>, EnigmaPlugboardCipher> {
    private JComboBox<EnigmaMachine> machineSelection;
    private JComboBox<String> reflectorSelection;
    private JTextField plugboardDefinition;

    public EnigmaPlugboardAttack() {
        super((ICipher)new EnigmaPlugboardCipher(EnigmaLib.ENIGMA_M3), "Enigma - Plugboard");
        this.setAttackMethods(new DecryptionMethod[]{DecryptionMethod.BRUTE_FORCE, DecryptionMethod.PERIODIC_KEY});
        this.machineSelection = new JComboBox();
        this.reflectorSelection = new JComboBox();
        this.plugboardDefinition = new JTextField();
        Stream.of(EnigmaLib.MACHINES).filter(m -> m.isSolvable() && m.canPlugboard() && !m.hasThinRotor()).forEach(this.machineSelection::addItem);
        this.machineSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EnigmaMachine currentMachine = (EnigmaMachine)EnigmaPlugboardAttack.this.machineSelection.getSelectedItem();
                EnigmaPlugboardAttack.this.reflectorSelection.removeAllItems();
                if (currentMachine.reflector.length > 1) {
                    EnigmaPlugboardAttack.this.reflectorSelection.addItem("-Check all-");
                }
                for (String reflectorName : currentMachine.reflectorNames) {
                    EnigmaPlugboardAttack.this.reflectorSelection.addItem(reflectorName);
                }
            }
        });
        EnigmaMachine currentMachine = (EnigmaMachine)this.machineSelection.getSelectedItem();
        if (currentMachine.reflector.length > 1) {
            this.reflectorSelection.addItem("-Check all-");
        }
        for (String reflectorName : currentMachine.reflectorNames) {
            this.reflectorSelection.addItem(reflectorName);
        }
    }

    public void createSettingsUI(JDialog dialog, JPanel panel) {
        panel.add(this.machineSelection);
        panel.add(this.reflectorSelection);
        panel.add(this.plugboardDefinition);
    }

    public IDecryptionTracker attemptAttack(CharSequence text, DecryptionMethod method, ICipherProgram app) {
        EnigmaTask tracker;
        block18: {
            tracker = new EnigmaTask(text, app);
            tracker.machine = (EnigmaMachine)this.machineSelection.getSelectedItem();
            ((EnigmaPlugboardCipher)this.getCipher()).setMachine(tracker.machine);
            tracker.reflectorTest = this.reflectorSelection.getSelectedIndex() - 1;
            tracker.start = 0;
            tracker.end = tracker.machine.getReflectorCount();
            if (tracker.reflectorTest != -1) {
                tracker.start = tracker.reflectorTest;
                tracker.end = tracker.start + 1;
            }
            String plugboardInput = this.plugboardDefinition.getText();
            int[][] plugboardDefinition = new int[13][2];
            boolean definitionProvided = false;
            int count = 0;
            for (String split : plugboardInput.split("[, ]")) {
                if (split.length() != 2) continue;
                plugboardDefinition[count][0] = split.charAt(0) - 65;
                plugboardDefinition[count++][1] = split.charAt(1) - 65;
                definitionProvided = true;
            }
            if (definitionProvided) {
                tracker.machine = tracker.machine.createWithPlugboard(plugboardDefinition);
            }
            this.output((IDecryptionTracker)tracker, "Using machine type: %s", new Object[]{tracker.machine});
            if (method == DecryptionMethod.BRUTE_FORCE) {
                BigInteger numRotors = MathUtil.factorialLength((BigInteger)BigInteger.valueOf(tracker.machine.getRotorCount()), (BigInteger)BigInteger.valueOf(3L));
                tracker.getProgress().addMax(numRotors.multiply(BigInteger.valueOf(26L).pow(3)).multiply(BigInteger.valueOf(tracker.end - tracker.start)));
                Timer timer = new Timer();
                KeyIterator.iterateIntegerArray(tracker::onList, (int)3, (int)tracker.machine.getRotorCount(), (boolean)false);
                this.output((IDecryptionTracker)tracker, "Time taken %fs", new Object[]{timer.getTimeRunning(TimeUnit.SECONDS)});
                tracker.squeezeFirst.sort();
                this.output((IDecryptionTracker)tracker, "Determining ring settings", new Object[0]);
                this.output((IDecryptionTracker)tracker, "%d possible indicators and rotor orders, therefore %d possible ring settings", new Object[]{tracker.squeezeFirst.size(), tracker.squeezeFirst.size() * 26 * 26});
                for (EnigmaAttack.EnigmaSection trial : tracker.squeezeFirst) {
                    for (int s2 = 0; s2 < 26; ++s2) {
                        for (int s3 = 0; s3 < 26; ++s3) {
                            if (!tracker.shouldStop()) {
                                Integer[] indicator = trial.copyIndicator();
                                Integer[] ring = new Integer[]{0, s2, s3};
                                indicator[1] = (indicator[1] + s2) % 26;
                                indicator[2] = (indicator[2] + s3) % 26;
                                char[] plainText = ((EnigmaPlugboardCipher)this.getCipher()).decodeEfficently(tracker.getCipherText(), tracker.getHolder(), (QuinKey<Integer[], Integer[], Integer[], Integer, Integer[]>)QuinKey.of((Object)indicator, (Object)ring, (Object)trial.rotors, (Object)trial.reflector, null));
                                EnigmaAttack.EnigmaSection nextTrialSolution = new EnigmaAttack.EnigmaSection(StatIC.calculateMonoIC((char[])plainText) * 1000.0, trial.machine, indicator, trial.rotors, trial.reflector);
                                nextTrialSolution.ring = ring;
                                if (tracker.squeezeSecond.add((Result)nextTrialSolution)) {
                                    nextTrialSolution.bake();
                                }
                                tracker.getProgress().increment();
                                continue;
                            }
                            break block18;
                        }
                    }
                }
                tracker.squeezeSecond.sort();
                this.output((IDecryptionTracker)tracker, "Determining plugboard", new Object[0]);
                for (EnigmaAttack.EnigmaSection trial : tracker.squeezeSecond) {
                    Integer[] plugboard = ArrayUtil.createRangeInteger((int)0, (int)26);
                    Integer[] possiblePlugBoard = ArrayUtil.createRangeInteger((int)0, (int)26);
                    Solution bestSolution = Solution.WORST_SOLUTION;
                    this.output((IDecryptionTracker)tracker, "============================", new Object[0]);
                    QuinKey key = QuinKey.of((Object)trial.indicator, (Object)trial.ring, (Object)trial.rotors, (Object)trial.reflector, (Object)plugboard);
                    for (int t = 0; t < 13; ++t) {
                        char[] plainText = ((EnigmaPlugboardCipher)this.getCipher()).decodeEfficently(tracker.getCipherText(), tracker.getHolder(), (QuinKey<Integer[], Integer[], Integer[], Integer, Integer[]>)key);
                        Solution bestLocalSolution = new Solution(plainText, StatIC.calculateMonoIC((char[])plainText) * 1000.0).setKeyString(((EnigmaPlugboardCipher)this.getCipher()).prettifyKey(key)).bake();
                        this.output((IDecryptionTracker)tracker, bestLocalSolution.toString(), new Object[0]);
                        int bestPlug1 = -1;
                        int bestPlug2 = -1;
                        char[] testText = ArrayUtil.copy((char[])plainText);
                        for (int i1 = 0; i1 < possiblePlugBoard.length - 1; ++i1) {
                            for (int i2 = i1 + 1; i2 < possiblePlugBoard.length; ++i2) {
                                if (!tracker.shouldStop()) {
                                    int plug1 = possiblePlugBoard[i1];
                                    int plug2 = possiblePlugBoard[i2];
                                    plugboard[plug2] = plug1;
                                    plugboard[plug1] = plug2;
                                    testText = ((EnigmaPlugboardCipher)this.getCipher()).decodeEfficently(tracker.getCipherText(), testText, (QuinKey<Integer[], Integer[], Integer[], Integer, Integer[]>)key);
                                    Solution lastSolution = new Solution(testText, StatIC.calculateMonoIC((char[])testText) * 1000.0);
                                    if (lastSolution.compareTo((Result)bestLocalSolution) < 0) {
                                        bestLocalSolution = lastSolution.setKeyString(((EnigmaPlugboardCipher)this.getCipher()).prettifyKey(key)).bake();
                                        bestPlug1 = plug1;
                                        bestPlug2 = plug2;
                                    }
                                    plugboard[plug2] = plug2;
                                    plugboard[plug1] = plug1;
                                    continue;
                                }
                                break block18;
                            }
                        }
                        if (bestPlug1 < 0) break;
                        plugboard[bestPlug2] = bestPlug1;
                        plugboard[bestPlug1] = bestPlug2;
                        Integer[] possiblePlugBoardNext = new Integer[possiblePlugBoard.length - 2];
                        int currentIndex = 0;
                        for (int i = 0; i < possiblePlugBoard.length; ++i) {
                            if (possiblePlugBoard[i] == bestPlug1 || possiblePlugBoard[i] == bestPlug2) continue;
                            possiblePlugBoardNext[currentIndex++] = possiblePlugBoard[i];
                        }
                        possiblePlugBoard = possiblePlugBoardNext;
                        if (bestLocalSolution.compareTo((Result)bestSolution) >= 0) continue;
                        bestSolution = bestLocalSolution;
                        this.output((IDecryptionTracker)tracker, bestSolution.toString(), new Object[0]);
                    }
                    if (!this.isBetterThanBest((IDecryptionTracker)tracker, bestSolution)) continue;
                    this.updateBestSolution((IDecryptionTracker)tracker, bestSolution, key);
                }
            } else if (method == DecryptionMethod.PERIODIC_KEY) {
                KeyIterator.iterateIntegerArray(tracker::onList3, (int)3, (int)3, (boolean)false);
            }
        }
        return tracker;
    }

    public class EnigmaTask
    extends DecryptionTracker {
        private EnigmaMachine machine;
        private int reflectorTest;
        private int start;
        private int end;
        private DynamicResultList<EnigmaAttack.EnigmaSection> squeezeFirst;
        private DynamicResultList<EnigmaAttack.EnigmaSection> squeezeSecond;

        public EnigmaTask(CharSequence text, ICipherProgram app) {
            super(text, app);
            this.squeezeFirst = new DynamicResultList(512);
            this.squeezeSecond = new DynamicResultList(128);
        }

        public boolean onList(Integer[] rotor) {
            return KeyIterator.iterateIntegerArray(o -> this.onList2(rotor, (Integer[])o), (int)3, (int)26, (boolean)true);
        }

        public boolean onList2(Integer[] rotor, Integer[] indicator) {
            for (int reflector = this.start; reflector < this.end; ++reflector) {
                char[] plainText = ((EnigmaPlugboardCipher)EnigmaPlugboardAttack.this.getCipher()).decodeEfficently(this.getCipherText(), this.getHolder(), (QuinKey<Integer[], Integer[], Integer[], Integer, Integer[]>)QuinKey.of((Object)indicator, (Object)EnigmaLib.DEFAULT_SETTING, (Object)rotor, (Object)reflector, null));
                EnigmaAttack.EnigmaSection trialSolution = new EnigmaAttack.EnigmaSection(StatIC.calculateMonoIC((char[])plainText) * 1000.0, this.machine, indicator, rotor, reflector);
                if (this.squeezeFirst.add((Result)trialSolution)) {
                    trialSolution.bake();
                }
                this.getProgress().increment();
            }
            return true;
        }

        public boolean onList3(Integer[] rotor) {
            return KeyIterator.iterateIntegerArray(o -> this.onList2(rotor, (Integer[])o), (int)3, (int)26, (boolean)true);
        }

        public boolean onList4(Integer[] rotor, Integer[] indicator) {
            block0: for (int reflector = this.start; reflector < this.end; ++reflector) {
                Integer[] plugboard = new Integer[26];
                Integer[] possiblePlugBoard = new Integer[26];
                for (int i = 0; i < 26; ++i) {
                    plugboard[i] = i;
                    possiblePlugBoard[i] = i;
                }
                while (true) {
                    char[] plainText = ((EnigmaPlugboardCipher)EnigmaPlugboardAttack.this.getCipher()).decodeEfficently(this.getCipherText(), this.getHolder(), (QuinKey<Integer[], Integer[], Integer[], Integer, Integer[]>)QuinKey.of((Object)indicator, (Object)EnigmaLib.DEFAULT_SETTING, (Object)rotor, (Object)reflector, (Object)plugboard));
                    Solution bestSolution = new Solution(plainText, StatIC.calculateMonoIC((char[])plainText) * 1000.0).bake();
                    int bestPlug1 = 0;
                    int bestPlug2 = 1;
                    char[] testText = ArrayUtil.copy((char[])plainText);
                    boolean foundFinalPlug = true;
                    for (int i1 = 0; i1 < possiblePlugBoard.length - 1; ++i1) {
                        for (int i2 = i1 + 1; i2 < possiblePlugBoard.length; ++i2) {
                            int plug1 = possiblePlugBoard[i1];
                            int plug2 = possiblePlugBoard[i2];
                            plugboard[plug2] = plug1;
                            plugboard[plug1] = plug2;
                            testText = ((EnigmaPlugboardCipher)EnigmaPlugboardAttack.this.getCipher()).decodeEfficently(this.getCipherText(), this.getHolder(), (QuinKey<Integer[], Integer[], Integer[], Integer, Integer[]>)QuinKey.of((Object)indicator, (Object)EnigmaLib.DEFAULT_SETTING, (Object)rotor, (Object)reflector, (Object)plugboard));
                            Solution lastSolution = new Solution(testText, StatIC.calculateMonoIC((char[])testText) * 1000.0);
                            if (lastSolution.compareTo((Result)bestSolution) < 0) {
                                bestSolution = lastSolution;
                                bestPlug1 = plug1;
                                bestPlug2 = plug2;
                                foundFinalPlug = false;
                            }
                            plugboard[plug2] = plug2;
                            plugboard[plug1] = plug1;
                        }
                    }
                    if (foundFinalPlug) {
                        EnigmaAttack.EnigmaSection trialSolution = new EnigmaAttack.EnigmaSection(bestSolution.score, this.machine.createWithPresetPlugboard(plugboard), indicator, rotor, reflector);
                        if (!this.squeezeFirst.add((Result)trialSolution)) continue block0;
                        EnigmaPlugboardAttack.this.output((IDecryptionTracker)this, "%s", new Object[]{trialSolution});
                        trialSolution.bake();
                        continue block0;
                    }
                    plugboard[bestPlug2] = bestPlug1;
                    plugboard[bestPlug1] = bestPlug2;
                    Integer[] possiblePlugBoardNext = new Integer[possiblePlugBoard.length - 2];
                    int currentIndex = 0;
                    for (int i = 0; i < possiblePlugBoard.length; ++i) {
                        if (possiblePlugBoard[i] == bestPlug1 || possiblePlugBoard[i] == bestPlug2) continue;
                        possiblePlugBoardNext[currentIndex++] = possiblePlugBoard[i];
                    }
                    possiblePlugBoard = possiblePlugBoardNext;
                }
            }
            return true;
        }
    }
}

