/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers.solitaire;

import com.alexbarter.lib.util.ArrayUtil;
import java.util.Arrays;

public class Solitaire {
    public static final int JOKER_A = 52;
    public static final int JOKER_B = 53;
    public static final int TOTAL_CARDS = 54;

    public static void main(String[] args) {
        Integer[] start;
        Integer[] code = start = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 53, 52};
        for (int i = 0; i < 10; ++i) {
            code = Solitaire.nextCardOrder(code);
        }
        long test = System.nanoTime();
        for (int i = 0; i < 10000000; ++i) {
            code = Solitaire.nextCardOrder(code);
        }
        long duration = System.nanoTime() - test;
        System.out.println("Took: " + (double)duration / 1.0E10);
    }

    public static boolean isJoker(int card) {
        return card == 52 || card == 53;
    }

    public static Integer[] nextCardOrder(Integer[] oldCardOrder) {
        int maxJ;
        int minJ;
        int jT;
        Object[] cardOrder;
        int jA = ArrayUtil.indexOf((Object[])oldCardOrder, (int)0, (int)54, (Object)52);
        if (jA < 53) {
            cardOrder = Arrays.copyOf(oldCardOrder, oldCardOrder.length);
            cardOrder[jA] = cardOrder[jA + 1];
            ++jA;
        } else {
            cardOrder = new Integer[54];
            System.arraycopy(oldCardOrder, 0, cardOrder, 1, 53);
            jA = 0;
        }
        cardOrder[jA] = 52;
        int jB = ArrayUtil.indexOf((Object[])cardOrder, (int)0, (int)54, (Object)53);
        if (jB < 52) {
            cardOrder[jB] = cardOrder[jB + 1];
            cardOrder[jB + 1] = cardOrder[jB + 2];
            jT = jB;
            if (jT < jA && jA <= (jB += 2)) {
                --jA;
            }
        } else {
            jT = jB;
            System.arraycopy(cardOrder, jB -= 51, cardOrder, jB + 1, 51);
            if (jB <= jA && jA < jT) {
                ++jA;
            }
        }
        cardOrder[jB] = 53;
        Integer[] temp = new Integer[54];
        if (jA < jB) {
            minJ = jA;
            maxJ = jB;
        } else {
            minJ = jB;
            maxJ = jA;
        }
        temp[53] = cardOrder[maxJ++];
        int len = 54 - maxJ;
        System.arraycopy(cardOrder, maxJ, temp, 0, len);
        jT = len;
        len = ArrayUtil.indexOf((Object[])cardOrder, (int)minJ, (int)cardOrder.length, (Object)temp[53]) - minJ;
        System.arraycopy(cardOrder, minJ, temp, jT, len);
        jT += len;
        temp[jT++] = temp[53];
        System.arraycopy(cardOrder, 0, temp, jT, minJ);
        int finalCard = temp[53];
        if (!Solitaire.isJoker(finalCard)) {
            System.arraycopy(temp, ++finalCard, cardOrder, 0, 53 - finalCard);
            System.arraycopy(temp, 0, cardOrder, 53 - finalCard, finalCard + 1);
            cardOrder[53] = temp[53];
        } else {
            cardOrder = temp;
        }
        return cardOrder;
    }

    public static Integer[] countCut(Integer[] cardOrder, int deckSize, int size) {
        Integer[] c = new Integer[deckSize];
        int distanceFromEnd = deckSize - size - 2;
        int moveValue = size + 1;
        int lastCardIndex = deckSize - 1;
        System.arraycopy(cardOrder, 0, c, distanceFromEnd, moveValue);
        System.arraycopy(cardOrder, moveValue, c, 0, distanceFromEnd);
        System.arraycopy(cardOrder, lastCardIndex, c, lastCardIndex, 1);
        return c;
    }

    public static Integer[] createCardOrder(String key) {
        return Solitaire.createCardOrder(key, ArrayUtil.createRangeInteger((int)54));
    }

    public static Integer[] createCardOrder(String key, Integer[] startingOrder) {
        Integer[] cardOrder = startingOrder;
        int deckSize = cardOrder.length;
        for (int i = 0; i < key.length(); ++i) {
            cardOrder = Solitaire.nextCardOrder(cardOrder);
            cardOrder = Solitaire.countCut(cardOrder, deckSize, key.charAt(i) - 65);
        }
        return cardOrder;
    }

    public static void specialAttack(SolitaireAttack attack, Integer[] deck, Integer[] unknowns) {
        Solitaire.options(attack, deck, unknowns, attack.getSubBranches(), 0, new int[attack.getSubBranches()]);
    }

    public static void options(SolitaireAttack attack, Integer[] lastOrder, Integer[] unknowns, int times, int count, int[] keyStream) {
        int jA;
        if (times <= count) {
            attack.tryKeyStream(keyStream, lastOrder);
            return;
        }
        Object[] cardOrder = Arrays.copyOf(lastOrder, 54);
        int jT = ArrayUtil.indexOf((Object[])cardOrder, (int)0, (int)54, (Object)52);
        if (jT < 53) {
            jA = jT + 1;
            cardOrder[jT] = cardOrder[jA];
        } else {
            for (jA = 53; jA > 1; --jA) {
                cardOrder[jA] = cardOrder[jA - 1];
            }
            jA = 0;
        }
        cardOrder[jA] = 52;
        int jB = ArrayUtil.indexOf((Object[])cardOrder, (int)0, (int)54, (Object)53);
        if (jB < 52) {
            jT = jB + 1;
            cardOrder[jB] = cardOrder[jT];
            if (jA == jT) {
                jA = jB;
            }
            jB = jT + 1;
            cardOrder[jT] = cardOrder[jB];
            if (jA == jB) {
                jA = jT;
            }
        } else {
            jT = jB;
            jB -= 51;
            while (jT > jB) {
                cardOrder[jT] = cardOrder[jT - 1];
                if (jA == jT - 1) {
                    jA = jT;
                }
                --jT;
            }
        }
        cardOrder[jB] = 53;
        Integer[] tmp = new Integer[54];
        if (jA > jB) {
            jT = jA;
            jA = jB;
            jB = jT;
        }
        tmp[53] = cardOrder[jB++];
        jT = 0;
        while (jB < 54) {
            tmp[jT++] = cardOrder[jB++];
        }
        jB = jA;
        while (cardOrder[jB] != tmp[53]) {
            tmp[jT++] = cardOrder[jB++];
        }
        tmp[jT++] = tmp[53];
        jB = 0;
        while (jB < jA) {
            tmp[jT++] = cardOrder[jB++];
        }
        jB = tmp[53];
        if (jB < 0) {
            for (int uI1 = 0; uI1 < unknowns.length; ++uI1) {
                int unknown = unknowns[uI1];
                if (unknown < 0) continue;
                if (!Solitaire.isJoker(unknown)) {
                    jA = 0;
                    for (jT = unknown + 1; jT < 53; ++jT) {
                        cardOrder[jA++] = tmp[jT];
                    }
                    for (jT = 0; jT < unknown + 2; ++jT) {
                        cardOrder[jA++] = tmp[jT];
                    }
                    cardOrder[53] = unknown;
                } else {
                    cardOrder = tmp;
                }
                unknowns[uI1] = -1;
                Solitaire.insideOrder(attack, (Integer[])cardOrder, unknowns, times, count, keyStream);
                unknowns[uI1] = unknown;
            }
        } else {
            if (!Solitaire.isJoker(jB)) {
                jA = 0;
                for (jT = jB + 1; jT < 53; ++jT) {
                    cardOrder[jA++] = tmp[jT];
                }
                for (jT = 0; jT < jB + 2; ++jT) {
                    cardOrder[jA++] = tmp[jT];
                }
                cardOrder[53] = jB;
            } else {
                cardOrder = tmp;
            }
            Solitaire.insideOrder(attack, (Integer[])cardOrder, unknowns, times, count, keyStream);
        }
    }

    public static void insideOrder(SolitaireAttack attack, Integer[] cardOrder, Integer[] unknowns, int times, int count, int[] keyStream) {
        int firstCard = cardOrder[0];
        if (firstCard < 0) {
            for (int uI1 = 0; uI1 < unknowns.length; ++uI1) {
                int unknown = unknowns[uI1];
                if (unknown < 0) continue;
                if (unknown == 53) {
                    unknown = 52;
                }
                int possibleIndex = unknown + 1;
                int possible = cardOrder[possibleIndex];
                unknowns[uI1] = -1;
                if (Solitaire.isJoker(possible)) {
                    cardOrder[0] = unknown;
                    Solitaire.options(attack, cardOrder, unknowns, times, count, keyStream);
                } else if (possible < 0) {
                    for (int uI2 = 0; uI2 < unknowns.length; ++uI2) {
                        int streamUnknown = unknowns[uI2];
                        if (streamUnknown < 0 || streamUnknown == unknown) continue;
                        cardOrder[0] = unknown;
                        int last = cardOrder[possibleIndex];
                        cardOrder[possibleIndex] = streamUnknown;
                        keyStream[count] = streamUnknown;
                        unknowns[uI2] = -1;
                        Solitaire.options(attack, cardOrder, unknowns, times, count + 1, keyStream);
                        cardOrder[possibleIndex] = last;
                        unknowns[uI2] = streamUnknown;
                    }
                } else {
                    cardOrder[0] = unknown;
                    keyStream[count] = possible;
                    Solitaire.options(attack, cardOrder, unknowns, times, count + 1, keyStream);
                }
                unknowns[uI1] = unknown;
            }
        } else {
            int possibleIndex;
            int possible;
            if (firstCard == 53) {
                firstCard = 52;
            }
            if (Solitaire.isJoker(possible = cardOrder[possibleIndex = firstCard + 1].intValue())) {
                Solitaire.options(attack, cardOrder, unknowns, times, count, keyStream);
            } else if (possible < 0) {
                for (int uI2 = 0; uI2 < unknowns.length; ++uI2) {
                    int streamUnknown = unknowns[uI2];
                    if (streamUnknown < 0) continue;
                    int last = cardOrder[possibleIndex];
                    cardOrder[possibleIndex] = streamUnknown;
                    keyStream[count] = streamUnknown;
                    unknowns[uI2] = -1;
                    Solitaire.options(attack, cardOrder, unknowns, times, count + 1, keyStream);
                    cardOrder[possibleIndex] = last;
                    unknowns[uI2] = streamUnknown;
                }
            } else {
                keyStream[count] = possible;
                Solitaire.options(attack, cardOrder, unknowns, times, count + 1, keyStream);
            }
        }
    }

    public static String encode(String plainText, Integer[] cardOrder) {
        Object cipherText = "";
        int index = 0;
        while (index < plainText.length()) {
            int topCard = (cardOrder = Solitaire.nextCardOrder(cardOrder))[0];
            int keyStreamNumber = !Solitaire.isJoker(topCard) ? cardOrder[topCard + 1].intValue() : cardOrder[cardOrder.length - 1].intValue();
            if (Solitaire.isJoker(keyStreamNumber)) continue;
            cipherText = (String)cipherText + (char)((plainText.charAt(index) - 65 + (keyStreamNumber + 1)) % 26 + 65);
            ++index;
        }
        return cipherText;
    }

    public static char[] decodeWithKeyStream(char[] cipherText, int[] keyStream) {
        return Solitaire.decodeWithKeyStream(cipherText, 0, keyStream);
    }

    public static char[] decodeWithKeyStream(char[] cipherText, int startingIndex, int[] keyStream) {
        char[] plainText = new char[cipherText.length];
        int index = startingIndex;
        for (int i = 0; i < index; ++i) {
            plainText[i] = (char)(cipherText[i] + 65);
        }
        for (int keyStreamNumber : keyStream) {
            plainText[index] = (char)((51 + cipherText[index] - keyStreamNumber) % 26 + 65);
            ++index;
        }
        return plainText;
    }

    public static char[] decode(char[] cipherText, Integer[] cardOrder) {
        return Solitaire.decode(cipherText, 0, cardOrder);
    }

    public static char[] decode(char[] cipherText, int startingIndex, Integer[] cardOrder) {
        char[] plainText = new char[cipherText.length];
        int index = startingIndex;
        for (int i = 0; i < index; ++i) {
            plainText[i] = cipherText[i];
        }
        while (index < cipherText.length) {
            int topCard = (cardOrder = Solitaire.nextCardOrder(cardOrder))[0];
            int keyStreamNumber = !Solitaire.isJoker(topCard) ? cardOrder[topCard + 1].intValue() : cardOrder[cardOrder.length - 1].intValue();
            if (Solitaire.isJoker(keyStreamNumber)) continue;
            plainText[index] = (char)((52 + (cipherText[index] - 65) - (keyStreamNumber + 1)) % 26 + 65);
            ++index;
        }
        return plainText;
    }

    public static byte[] decode(byte[] cipherText, int startingIndex, Integer[] cardOrder) {
        byte[] plainText = new byte[cipherText.length];
        int index = startingIndex;
        for (int i = 0; i < index; ++i) {
            plainText[i] = cipherText[i];
        }
        while (index < cipherText.length) {
            int topCard = (cardOrder = Solitaire.nextCardOrder(cardOrder))[0];
            int keyStreamNumber = !Solitaire.isJoker(topCard) ? cardOrder[topCard + 1].intValue() : cardOrder[cardOrder.length - 1].intValue();
            if (Solitaire.isJoker(keyStreamNumber)) continue;
            plainText[index] = (byte)((52 + (cipherText[index] - 65) - (keyStreamNumber + 1)) % 26 + 65);
            ++index;
        }
        return plainText;
    }

    public static interface SolitaireAttack {
        public void tryKeyStream(int[] var1, Integer[] var2);

        public int getSubBranches();
    }

    public static class Deck {
        public int jA;
        public int jB;
        public int[] cards;

        public Deck(int[] cards) {
            this.cards = cards;
            this.jA = ArrayUtil.indexOf((int[])this.cards, (int)0, (int)54, (int)52);
            this.jB = ArrayUtil.indexOf((int[])this.cards, (int)0, (int)54, (int)53);
        }
    }
}

