/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.BiKey;
import com.alexbarter.ciphertool.base.ciphers.BiKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.EnumKeyType;
import com.alexbarter.ciphertool.base.key.types.OrderedIntegerKeyType;
import com.alexbarter.ciphertool.util.ReadMode;
import com.alexbarter.lib.util.ArrayUtil;
import javax.annotation.Nullable;

public class ColumnarTranspositionCipher
extends BiKeyCipher<Integer[], ReadMode, OrderedIntegerKeyType.Builder, EnumKeyType.Builder<ReadMode>> {
    public ColumnarTranspositionCipher() {
        super((IKeyType.IKeyBuilder)OrderedIntegerKeyType.builder().setRange(2, Integer.MAX_VALUE), (IKeyType.IKeyBuilder)EnumKeyType.builder(ReadMode.class).setUniverse((Enum[])ReadMode.values()));
    }

    public IKeyType.IKeyBuilder<Integer[]> limitDomainForFirstKey(OrderedIntegerKeyType.Builder firstKey) {
        return firstKey.setRange(2, 9);
    }

    public CharSequence encode(CharSequence plainText, BiKey<Integer[], ReadMode> key) {
        Integer[] order = (Integer[])key.getFirstKey();
        StringBuilder[] columns = (StringBuilder[])ArrayUtil.fill((Object[])new StringBuilder[((Integer[])key.getFirstKey()).length], () -> new StringBuilder((int)Math.ceil((double)plainText.length() / (double)((Integer[])key.getFirstKey()).length)));
        int index = 0;
        block4: while (true) {
            int col = 0;
            while (true) {
                if (col >= order.length) continue block4;
                if (index >= plainText.length()) break block4;
                columns[order[col]].append(plainText.charAt(Math.min(index++, plainText.length() - 1)));
                ++col;
            }
            break;
        }
        StringBuilder read = new StringBuilder(plainText.length());
        switch ((ReadMode)((Object)key.getSecondKey())) {
            case ACROSS: {
                int rows = (int)Math.ceil((double)plainText.length() / (double)order.length);
                for (int row = 0; row < rows; ++row) {
                    for (int col = 0; col < order.length; ++col) {
                        if (row >= columns[col].length()) continue;
                        read.append(columns[col].charAt(row));
                    }
                }
                break;
            }
            case DOWN: {
                for (int i = 0; i < order.length; ++i) {
                    read.append((CharSequence)columns[i]);
                }
                break;
            }
        }
        return read;
    }

    public char[] decodeEfficently(CharSequence cipherText, @Nullable char[] plainText, BiKey<Integer[], ReadMode> key) {
        Integer[] order = (Integer[])key.getFirstKey();
        Integer[] orderIndex = ArrayUtil.toIndexedArray((Integer[])order);
        int period = order.length;
        int rows = (int)Math.ceil((double)cipherText.length() / (double)period);
        int index = 0;
        switch ((ReadMode)((Object)key.getSecondKey())) {
            case DOWN: {
                block4: for (int col = 0; col < period; ++col) {
                    int trueColumn = orderIndex[col];
                    for (int row = 0; row < rows; ++row) {
                        if (row * period + trueColumn >= cipherText.length()) continue;
                        if (index >= cipherText.length()) continue block4;
                        plainText[row * period + trueColumn] = cipherText.charAt(index++);
                    }
                }
                break;
            }
            case ACROSS: {
                block6: for (int row = 0; row < rows; ++row) {
                    for (int col = 0; col < period; ++col) {
                        int trueColumn = orderIndex[col];
                        if (row * period + trueColumn >= cipherText.length()) continue;
                        if (index >= cipherText.length()) continue block6;
                        plainText[row * period + trueColumn] = cipherText.charAt(index++);
                    }
                }
                break;
            }
        }
        return plainText;
    }
}

