/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.BiKey;
import com.alexbarter.ciphertool.base.ciphers.BiKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.IntegerGenKeyType;
import com.alexbarter.ciphertool.base.key.types.IntegerKeyType;
import com.alexbarter.ciphertool.lib.CipherUtils;
import com.alexbarter.lib.util.MathUtil;
import java.math.BigInteger;
import javax.annotation.Nullable;

public class AffineCipher
extends BiKeyCipher<Integer, Integer, IntegerGenKeyType.Builder, IntegerKeyType.Builder> {
    public AffineCipher() {
        super((IKeyType.IKeyBuilder)IntegerGenKeyType.builder().setRange(0, 25).addFilter(MathUtil::hasInverseMod26), (IKeyType.IKeyBuilder)IntegerKeyType.builder().setRange(0, 25));
    }

    public CharSequence encode(CharSequence plainText, BiKey<Integer, Integer> key) {
        int i;
        StringBuilder cipherText = new StringBuilder(plainText.length());
        StringBuilder tempAlphabet = new StringBuilder(26);
        for (i = 0; i < 26; ++i) {
            tempAlphabet.append((char)(65 + ((Integer)key.getFirstKey() * i + (Integer)key.getSecondKey()) % 26));
        }
        for (i = 0; i < plainText.length(); ++i) {
            byte ch = CipherUtils.getAlphaIndex((char)plainText.charAt(i));
            if (ch == -1) continue;
            char newLetter = tempAlphabet.charAt(plainText.charAt(i) - 65);
            cipherText.append(newLetter);
        }
        return cipherText;
    }

    public char[] decodeEfficently(CharSequence cipherText, @Nullable char[] plainText, BiKey<Integer, Integer> key) {
        int multiplicativeInverse = BigInteger.valueOf(((Integer)key.getFirstKey()).intValue()).modInverse(BigInteger.valueOf(26L)).intValue();
        for (int i = 0; i < cipherText.length(); ++i) {
            plainText[i] = (char)(MathUtil.mod((int)(multiplicativeInverse * (cipherText.charAt(i) - 65 - (Integer)key.getSecondKey())), (int)26) + 65);
        }
        return plainText;
    }
}

