/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.key.types;

import com.alexbarter.lib.util.RandomUtil;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.IRangedKeyType;
import tools.cipher.base.key.KeyGeneration;
import tools.cipher.lib.ListUtil;

public class SwagmanKeyType
implements IKeyType<int[]> {
    private final int min;
    private final int max;

    private SwagmanKeyType(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public int[] randomise() {
        return KeyGeneration.createSwagmanKey(RandomUtil.pickRandomInt((int)this.min, (int)this.max));
    }

    @Override
    public boolean isValid(int[] key) {
        List test;
        double sizeD = Math.sqrt(key.length);
        if (sizeD != Math.floor(sizeD)) {
            return false;
        }
        int size = (int)sizeD;
        for (int row = 0; row < size; ++row) {
            test = ListUtil.randomRange((int)0, (int)(size - 1));
            for (int col = 0; col < size; ++col) {
                if (test.remove((Object)key[row * size + col])) continue;
                return false;
            }
        }
        for (int col = 0; col < size; ++col) {
            test = ListUtil.randomRange((int)0, (int)(size - 1));
            for (int row = 0; row < size; ++row) {
                if (test.remove((Object)key[row * size + col])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean iterateKeys(Function<int[], Boolean> consumer) {
        for (int length = this.min; length <= this.max; ++length) {
        }
        return true;
    }

    @Override
    public int[] alterKey(int[] key) {
        return key;
    }

    @Override
    public BigInteger getNumOfKeys() {
        return BigInteger.ZERO;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements IRangedKeyType.IRangedKeyBuilder<int[]> {
        private Optional<Integer> min = Optional.empty();
        private Optional<Integer> max = Optional.empty();

        private Builder() {
        }

        public Builder setMin(int min) {
            this.min = Optional.of(min);
            return this;
        }

        public Builder setMax(int max) {
            this.max = Optional.of(max);
            return this;
        }

        public Builder setRange(int min, int max) {
            return this.setMin(min).setMax(max);
        }

        public Builder setSize(int size) {
            return this.setRange(size, size);
        }

        public SwagmanKeyType create() {
            SwagmanKeyType handler = new SwagmanKeyType(this.min.orElse(3), this.max.orElse(5));
            return handler;
        }
    }
}

