/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.interfaces;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import tools.cipher.base.interfaces.ILoadHook;

public interface ISettings {
    public ISettings put(String var1, Object var2);

    public Object getRaw(String var1, Object var2);

    default public <T> T get(String key, T default_) {
        return (T)this.get(key, x -> x, default_.getClass(), default_);
    }

    default public <T> List<T> getList(String key, List<T> default_) {
        return this.get(key, x -> x, List.class, default_);
    }

    default public <T> Map<String, T> getMap(String key, Map<String, T> default_) {
        return this.get(key, x -> x, Map.class, default_);
    }

    default public <I, T> T get(String key, Function<I, T> inputTransformer, Class<I> type, T default_) {
        Object raw = this.getRaw(key, null);
        if (raw != null && type.isAssignableFrom(raw.getClass())) {
            return inputTransformer.apply(raw);
        }
        return default_;
    }

    public void save();

    public void load();

    public void addHook(ILoadHook var1);

    public void markDirty();

    public boolean isDirty();
}

