/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.key.types;

import com.alexbarter.lib.util.MathUtil;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Optional;
import java.util.function.Function;
import tools.cipher.base.interfaces.IKeyType;
import tools.cipher.base.key.KeyGeneration;
import tools.cipher.base.key.KeyIterator;
import tools.cipher.base.key.KeyManipulation;
import tools.cipher.lib.characters.CharSequenceUtils;

public class SquareStringKeyType
implements IKeyType<String> {
    private final CharSequence alphabet;
    private int rows;
    private int columns;

    private SquareStringKeyType(CharSequence alphabet, int rows, int columns) {
        this.alphabet = alphabet;
        this.rows = rows;
        this.columns = columns;
    }

    @Override
    public String randomise() {
        return KeyGeneration.createLongKeyUniversal(this.alphabet);
    }

    @Override
    public boolean isValid(String key) {
        if (key.length() != this.alphabet.length()) {
            return false;
        }
        for (int i = 0; i < key.length(); ++i) {
            if (CharSequenceUtils.contains((CharSequence)this.alphabet, (char)key.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean iterateKeys(Function<String, Boolean> consumer) {
        return KeyIterator.permuteString(consumer, this.alphabet);
    }

    @Override
    public String alterKey(String key) {
        return KeyManipulation.modifyKeySquare(key, this.columns, this.rows);
    }

    @Override
    public BigInteger getNumOfKeys() {
        return MathUtil.factorialBig((BigInteger)BigInteger.valueOf(this.alphabet.length()));
    }

    @Override
    public String parse(String input) throws ParseException {
        return input;
    }

    @Override
    public String getHelp() {
        return "keysquare" + this.rows + "x" + this.columns;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements IKeyType.IKeyBuilder<String> {
        private Optional<CharSequence> alphabet = Optional.empty();
        private Optional<Integer> rows = Optional.empty();
        private Optional<Integer> columns = Optional.empty();

        private Builder() {
        }

        public Builder setAlphabet(CharSequence alphabet) {
            this.alphabet = Optional.of(alphabet);
            return this;
        }

        public Builder setDim(int rows, int columns) {
            this.rows = Optional.of(rows);
            this.columns = Optional.of(columns);
            return this;
        }

        public SquareStringKeyType create() {
            CharSequence alphabet = this.alphabet.orElse("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
            SquareStringKeyType handler = new SquareStringKeyType(alphabet, this.rows.orElse(1), this.columns.orElse(alphabet.length()));
            return handler;
        }
    }
}

