/*
 * Decompiled with CFR 0.152.
 */
package tools.cipher.base.key.types;

import com.alexbarter.lib.util.ArrayUtil;
import com.alexbarter.lib.util.MathUtil;
import com.alexbarter.lib.util.RandomUtil;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import tools.cipher.base.key.IRangedKeyType;
import tools.cipher.lib.ListUtil;
import tools.cipher.lib.characters.CharSequenceUtils;

public class PlugboardKeyType
implements IRangedKeyType<Integer[]> {
    private int plugboardSize;
    private int minPlugs;
    private int maxPlugs;

    private PlugboardKeyType(int plugboardSize, int minPlugs, int maxPlugs) {
        this.plugboardSize = plugboardSize;
        this.minPlugs = minPlugs;
        this.maxPlugs = maxPlugs;
    }

    @Override
    public Integer[] randomise() {
        int numPlugs = RandomUtil.pickRandomInt((int)this.minPlugs, (int)this.maxPlugs);
        Integer[] key = ArrayUtil.createRangeInteger((int)0, (int)this.plugboardSize);
        List plugs = ListUtil.range((int)0, (int)(this.plugboardSize - 1));
        for (int i = 0; i < numPlugs; ++i) {
            int plug1 = (Integer)RandomUtil.removeRandomElement((List)plugs);
            int plug2 = (Integer)RandomUtil.removeRandomElement((List)plugs);
            key[plug1] = plug2;
            key[plug2] = plug1;
        }
        return key;
    }

    @Override
    public boolean iterateKeys(Function<Integer[], Boolean> consumer) {
        for (int n = this.minPlugs; n <= this.maxPlugs; ++n) {
            Integer[] key = ArrayUtil.createRangeInteger((int)0, (int)this.plugboardSize);
            for (int i = 0; i < n; ++i) {
            }
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Integer[] alterKey(Integer[] key) {
        return key;
    }

    @Override
    public boolean isValid(Integer[] key) {
        if (key.length != this.plugboardSize) {
            return false;
        }
        for (int i = 0; i < this.plugboardSize; ++i) {
            if (key[i] < 0 || key[i] >= this.plugboardSize) {
                return false;
            }
            if (key[key[i]] == i) continue;
            return false;
        }
        return true;
    }

    @Override
    public Integer[] parse(String input) throws ParseException {
        String[] elements = input.split("-");
        if (elements.length > 13) {
            throw new ParseException("Plugboard has too many plugs - max 13", 0);
        }
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].length() > 2) {
                throw new ParseException("Plug has too many letters", i * 3);
            }
            if (elements[i].length() < 2) {
                throw new ParseException("Plug has too many letters", i * 3);
            }
            elements[i] = elements[i].toUpperCase(Locale.ROOT);
            if (!CharSequenceUtils.isCharSubset((CharSequence)elements[i], (CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ")) {
                throw new ParseException("Plug has invalid letters", i * 3);
            }
            if (elements[i].charAt(0) != elements[i].charAt(1)) continue;
            throw new ParseException("Plug has duplicate letters", i * 3);
        }
        Integer[] key = ArrayUtil.createRangeInteger((int)0, (int)26);
        for (int i = 0; i < elements.length; ++i) {
            int val1 = elements[i].charAt(0) - 65;
            int val2 = elements[i].charAt(1) - 65;
            if (key[val1] != val1 || key[val2] != val2) {
                throw new ParseException("Plug uses letters that have already been used", i * 3);
            }
            key[val1] = val2;
            key[val2] = val1;
        }
        return key;
    }

    @Override
    public String getHelp() {
        return "Plugs:AB-UJ-DH";
    }

    @Override
    public String prettifyKey(Integer[] key) {
        StringJoiner joiner = new StringJoiner(" ", "[", "]");
        ArrayList<Integer> plugsUsed = new ArrayList<Integer>(key.length / 2);
        for (int i = 0; i < key.length; ++i) {
            int other;
            if (plugsUsed.contains(i) || (other = ArrayUtil.indexOf((Object[])key, (Object)i)) == i) continue;
            joiner.add(String.format("%c%c", Character.valueOf((char)(i + 65)), Character.valueOf((char)(other + 65))));
            plugsUsed.add(i);
            plugsUsed.add(other);
        }
        return joiner.toString();
    }

    @Override
    public BigInteger getNumOfKeys() {
        BigInteger total = BigInteger.ONE;
        BigInteger numTotal = BigInteger.valueOf(this.plugboardSize);
        for (int i = 1; i <= this.plugboardSize / 2; ++i) {
            total = total.add(MathUtil.chooseNumPairs((BigInteger)BigInteger.valueOf(i), (BigInteger)numTotal));
        }
        return total;
    }

    @Override
    public int getMin() {
        return this.minPlugs;
    }

    @Override
    public int getMax() {
        return this.maxPlugs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements IRangedKeyType.IRangedKeyBuilder<Integer[]> {
        private Optional<Integer> min = Optional.empty();
        private Optional<Integer> max = Optional.empty();

        private Builder() {
        }

        public Builder setMin(int min) {
            this.min = Optional.of(min);
            return this;
        }

        public Builder setMax(int max) {
            this.max = Optional.of(max);
            return this;
        }

        public Builder setRange(int min, int max) {
            return this.setMin(min).setMax(max);
        }

        public Builder setSize(int size) {
            return this.setRange(size, size);
        }

        public PlugboardKeyType create() {
            PlugboardKeyType handler = new PlugboardKeyType(26, this.min.orElse(0), this.max.orElse(13));
            return handler;
        }
    }
}

